/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.utils;

import com.cibernet.splatcraft.entities.classes.EntityInkProjectile;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.SplatCraftUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InkExplosion {
    private final boolean damagesTerrain;
    private final World world;
    private final double x;
    private final double y;
    private final double z;
    private final int color;
    private final Entity exploder;
    private final float size;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<EntityPlayer, Vec3d> playerKnockbackMap = Maps.newHashMap();
    private final Vec3d position;
    private float damage;
    private float terrainDamage = 0.0f;
    private boolean glowingInk = false;

    @SideOnly(value=Side.CLIENT)
    public InkExplosion(World worldIn, Entity entityIn, double x, double y, double z, int size, int color, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, size, color, true, affectedPositions);
    }

    @SideOnly(value=Side.CLIENT)
    public InkExplosion(World worldIn, Entity entityIn, double x, double y, double z, int size, int color, boolean damagesTerrain, List<BlockPos> affectedPositions) {
        this(worldIn, entityIn, x, y, z, (float)size, color, damagesTerrain);
        this.affectedBlockPositions.addAll(affectedPositions);
    }

    public InkExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, int color, float damage, boolean damagesTerrain) {
        this.world = worldIn;
        this.exploder = entityIn;
        this.size = size;
        this.x = x;
        this.y = y;
        this.z = z;
        this.damagesTerrain = damagesTerrain;
        this.position = new Vec3d(this.x, this.y, this.z);
        this.color = color;
        this.damage = damage;
        if (entityIn instanceof EntityInkProjectile) {
            this.terrainDamage = ((EntityInkProjectile)entityIn).getDamage();
        }
    }

    public InkExplosion(World worldIn, Entity entityIn, double x, double y, double z, float size, int color, boolean damagesTerrain) {
        this(worldIn, entityIn, x, y, z, size, color, 0.0f, damagesTerrain);
    }

    public InkExplosion setInkType(boolean isGlowing) {
        this.glowingInk = isGlowing;
        return this;
    }

    public void doExplosionA() {
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int j = 0; j < 16; ++j) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    if (j != 0 && j != 15 && k != 0 && k != 15 && l != 0 && l != 15) continue;
                    double d0 = (float)j / 15.0f * 2.0f - 1.0f;
                    double d1 = (float)k / 15.0f * 2.0f - 1.0f;
                    double d2 = (float)l / 15.0f * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double d4 = this.x + 0.25;
                    double d6 = this.y + 0.25;
                    double d8 = this.z + 0.25;
                    float f1 = 0.3f;
                    for (float f = this.size * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        IBlockState iblockstate;
                        RayTraceResult rayTrace = SplatCraftUtils.rayTraceBlocks(this.world, new Vec3d(this.x + 0.5, this.y + 0.5, this.z + 0.5), new Vec3d(d4 + 0.5, d6 + 0.5, d8 + 0.5));
                        BlockPos blockpos = new BlockPos(d4, d6, d8);
                        if (rayTrace != null) {
                            blockpos = rayTrace.func_178782_a();
                        }
                        if ((iblockstate = this.world.func_180495_p(blockpos)).func_185904_a() != Material.field_151579_a) {
                            float f2 = 0.0f;
                            f -= (f2 + 0.3f) * 0.3f;
                        }
                        if (f > 0.0f && !set.contains(blockpos)) {
                            set.add(blockpos);
                        }
                        d4 += d0 * (double)0.3f;
                        d6 += d1 * (double)0.3f;
                        d8 += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.size * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.x - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.x + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.y - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.y + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.z - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.z + (double)f3 + 1.0));
        List list = this.world.func_72839_b((Entity)this.getExplosivePlacedBy(), new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        Vec3d vec3d = new Vec3d(this.x, this.y, this.z);
        if (this.damage != 0.0f) {
            for (int k2 = 0; k2 < list.size(); ++k2) {
                double d9;
                double d7;
                double d5;
                double d13;
                double d12;
                Entity entity = (Entity)list.get(k2);
                if (entity.func_180427_aV() || !((d12 = entity.func_70011_f(this.x, this.y, this.z) / (double)f3) <= 1.0) || (d13 = (double)MathHelper.func_76133_a((double)((d5 = entity.field_70165_t - this.x) * d5 + (d7 = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * d7 + (d9 = entity.field_70161_v - this.z) * d9))) == 0.0) continue;
                InkColors inkColor = InkColors.getByColor(this.color);
                if (entity instanceof EntitySheep && inkColor != null && inkColor.getDyeColor() != null) {
                    ((EntitySheep)entity).func_175512_b(inkColor.getDyeColor());
                }
                if (!(entity instanceof EntityLivingBase)) continue;
                SplatCraftUtils.dealInkDamage(this.world, (EntityLivingBase)entity, this.damage, this.color, (Entity)this.getExplosivePlacedBy(), false, this.glowingInk);
            }
        }
    }

    public void doExplosionB(boolean spawnParticles) {
        if (this.size >= 2.0f && this.damagesTerrain) {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_HUGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        } else {
            this.world.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, this.x, this.y, this.z, 1.0, 0.0, 0.0, new int[0]);
        }
        if (this.damagesTerrain) {
            for (BlockPos blockpos : this.affectedBlockPositions) {
                IBlockState iblockstate = this.world.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (spawnParticles) {
                    double d0 = (float)blockpos.func_177958_n() + this.world.field_73012_v.nextFloat();
                    double d1 = (float)blockpos.func_177956_o() + this.world.field_73012_v.nextFloat();
                    double d2 = (float)blockpos.func_177952_p() + this.world.field_73012_v.nextFloat();
                    double d3 = d0 - this.x;
                    double d4 = d1 - this.y;
                    double d5 = d2 - this.z;
                    double d6 = MathHelper.func_76133_a((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.size + 0.1);
                    this.world.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (d0 + this.x) / 2.0, (d1 + this.y) / 2.0, (d2 + this.z) / 2.0, d3 *= (d7 *= (double)(this.world.field_73012_v.nextFloat() * this.world.field_73012_v.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7, new int[0]);
                    this.world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, d3, d4, d5, new int[0]);
                }
                if (iblockstate.func_185904_a() == Material.field_151579_a) continue;
                EntityLivingBase placer = this.getExplosivePlacedBy();
                if (placer instanceof EntityPlayer) {
                    SplatCraftUtils.playerInkBlock((EntityPlayer)placer, this.world, blockpos, this.color, this.terrainDamage, this.glowingInk);
                    continue;
                }
                SplatCraftUtils.inkBlock(this.world, blockpos, this.color, this.terrainDamage, this.glowingInk);
            }
        }
    }

    public Map<EntityPlayer, Vec3d> getPlayerKnockbackMap() {
        return this.playerKnockbackMap;
    }

    public void clearAffectedBlockPositions() {
        this.affectedBlockPositions.clear();
    }

    public List<BlockPos> getAffectedBlockPositions() {
        return this.affectedBlockPositions;
    }

    public Vec3d getPosition() {
        return this.position;
    }

    @Nullable
    public EntityLivingBase getExplosivePlacedBy() {
        if (this.exploder == null) {
            return null;
        }
        if (this.exploder instanceof EntityInkProjectile) {
            return ((EntityInkProjectile)this.exploder).getThrower();
        }
        return this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null;
    }
}

