/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.utils;

import com.cibernet.splatcraft.blocks.BlockInkColor;
import com.cibernet.splatcraft.blocks.BlockInkedSlab;
import com.cibernet.splatcraft.blocks.BlockInkedStairs;
import com.cibernet.splatcraft.blocks.BlockInkedWool;
import com.cibernet.splatcraft.blocks.BlockSCBarrier;
import com.cibernet.splatcraft.blocks.BlockSquidPassable;
import com.cibernet.splatcraft.blocks.IInked;
import com.cibernet.splatcraft.entities.classes.EntitySquidBumper;
import com.cibernet.splatcraft.particles.SplatCraftParticleSpawner;
import com.cibernet.splatcraft.registries.SplatCraftBlocks;
import com.cibernet.splatcraft.registries.SplatCraftItems;
import com.cibernet.splatcraft.registries.SplatCraftStats;
import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.tileentities.TileEntityColor;
import com.cibernet.splatcraft.tileentities.TileEntityInkedBlock;
import com.cibernet.splatcraft.tileentities.TileEntityStageBarrier;
import com.cibernet.splatcraft.tileentities.TileEntitySunkenCrate;
import com.cibernet.splatcraft.utils.InkColors;
import com.cibernet.splatcraft.utils.InkExplosion;
import com.cibernet.splatcraft.utils.SplatCraftDamageSource;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.IScoreCriteria;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class SplatCraftUtils {
    private static List<Block> cantPassthrough = Arrays.asList(Blocks.field_180401_cv, Blocks.field_150431_aC, Blocks.field_150404_cg);

    public static void setEntitySize(Entity entityIn, float width, float height) {
        if (width != entityIn.field_70130_N || height != entityIn.field_70131_O) {
            float f = entityIn.field_70130_N;
            entityIn.field_70130_N = width;
            entityIn.field_70131_O = height;
            if (entityIn.field_70130_N < f) {
                double d0 = (double)width / 2.0;
                entityIn.func_174826_a(new AxisAlignedBB(entityIn.field_70165_t - d0, entityIn.field_70163_u, entityIn.field_70161_v - d0, entityIn.field_70165_t + d0, entityIn.field_70163_u + (double)entityIn.field_70131_O, entityIn.field_70161_v + d0));
                return;
            }
            AxisAlignedBB axisalignedbb = entityIn.func_174813_aQ();
            entityIn.func_174826_a(new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b, axisalignedbb.field_72339_c, axisalignedbb.field_72340_a + (double)entityIn.field_70130_N, axisalignedbb.field_72338_b + (double)entityIn.field_70131_O, axisalignedbb.field_72339_c + (double)entityIn.field_70130_N));
            if (entityIn.field_70130_N > f && !entityIn.field_70170_p.field_72995_K) {
                entityIn.func_70091_d(MoverType.SELF, (double)(f - entityIn.field_70130_N), 0.0, (double)(f - entityIn.field_70130_N));
            }
        }
    }

    private static boolean dealDamage(World world, EntityLivingBase target, float damage, int color, Entity source, boolean damageMobs, boolean glowingInk, String type) {
        boolean doDamage = false;
        boolean wasDead = target.func_110143_aJ() <= 0.0f;
        int targetColor = 0;
        if (target instanceof EntityPlayer) {
            targetColor = SplatCraftPlayerData.getInkColor((EntityPlayer)target);
            if (targetColor != color) {
                doDamage = true;
            }
        } else if (target instanceof EntitySquidBumper) {
            if (((EntitySquidBumper)target).getColor() != color) {
                doDamage = true;
            }
        } else {
            doDamage = damageMobs;
        }
        if (doDamage) {
            target.func_70097_a((DamageSource)new SplatCraftDamageSource(type, source, source), damage);
        }
        if (target instanceof EntityPlayer && !wasDead && target.func_110143_aJ() <= 0.0f && doDamage) {
            Score score;
            SplatCraftUtils.createInkExplosion(world, (Entity)target, new BlockPos(target.field_70165_t, target.field_70163_u, target.field_70161_v), 2.0f, 0.0f, color, glowingInk);
            if (SplatcraftScoreboardHandler.hasGoal(color)) {
                for (ScoreObjective scoreobjective : world.func_96441_U().func_96520_a((IScoreCriteria)SplatcraftScoreboardHandler.getKillsAsColor(color))) {
                    score = world.func_96441_U().func_96529_a(source.func_70005_c_(), scoreobjective);
                    score.func_96648_a();
                }
            }
            if (SplatcraftScoreboardHandler.hasGoal(targetColor)) {
                for (ScoreObjective scoreobjective : world.func_96441_U().func_96520_a((IScoreCriteria)SplatcraftScoreboardHandler.getColorKills(targetColor))) {
                    score = world.func_96441_U().func_96529_a(source.func_70005_c_(), scoreobjective);
                    score.func_96648_a();
                }
                for (ScoreObjective scoreobjective : world.func_96441_U().func_96520_a((IScoreCriteria)SplatcraftScoreboardHandler.getDeathsAsColor(targetColor))) {
                    score = world.func_96441_U().func_96529_a(target.func_70005_c_(), scoreobjective);
                    score.func_96648_a();
                }
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 32; ++i) {
                    SplatCraftParticleSpawner.spawnInkParticle(target.field_70165_t, target.field_70163_u, target.field_70161_v, 0.0, 0.0, 0.0, color, 2.0f);
                }
            }
        }
        return doDamage;
    }

    public static boolean dealRollDamage(World worldIn, EntityLivingBase target, float damage, int color, Entity source, boolean damageMobs, boolean glowingInk) {
        return SplatCraftUtils.dealDamage(worldIn, target, damage, color, source, damageMobs, glowingInk, "roll");
    }

    public static boolean dealInkDamage(World worldIn, EntityLivingBase target, float damage, int color, Entity source, boolean damageMobs, boolean glowingInk) {
        boolean damaged = SplatCraftUtils.dealDamage(worldIn, target, damage, color, source, damageMobs, glowingInk, "splat");
        return damaged;
    }

    public static boolean canSquidHide(World worldIn, EntityPlayer playerIn) {
        BlockPos pos = new BlockPos(playerIn.field_70165_t, playerIn.field_70163_u - 0.1, playerIn.field_70161_v);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if ((!(block instanceof IInked) || block instanceof IInked && ((IInked)block).canSwim()) && worldIn.func_175625_s(pos) instanceof TileEntityColor) {
            return (SplatCraftGamerules.getGameruleValue("universalInk") || ((TileEntityColor)worldIn.func_175625_s(pos)).getColor() == SplatCraftPlayerData.getInkColor(playerIn)) && !playerIn.func_184218_aH();
        }
        return SplatCraftUtils.canSquidClimb(worldIn, playerIn);
    }

    public static boolean getPlayerGlowingInk(EntityPlayer player) {
        return player.field_71071_by.func_70431_c(new ItemStack(SplatCraftItems.splatfestBand));
    }

    public static boolean canSquidClimb(World worldIn, EntityPlayer playerIn) {
        if (SplatCraftUtils.onEnemyInk(worldIn, playerIn)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            float zOff;
            float xOff = (i < 2 ? 0.32f : 0.0f) * (float)(i % 2 == 0 ? 1 : -1);
            BlockPos pos = new BlockPos(playerIn.field_70165_t - (double)xOff, playerIn.field_70163_u, playerIn.field_70161_v - (double)(zOff = (i < 2 ? 0.0f : 0.32f) * (float)(i % 2 == 0 ? 1 : -1)));
            Block block = worldIn.func_180495_p(pos).func_177230_c();
            if (block instanceof IInked && (!(block instanceof IInked) || !((IInked)block).canClimb()) || !(worldIn.func_175625_s(pos) instanceof TileEntityColor) || !SplatCraftGamerules.getGameruleValue("universalInk") && ((TileEntityColor)worldIn.func_175625_s(pos)).getColor() != SplatCraftPlayerData.getInkColor(playerIn) || playerIn.func_184218_aH()) continue;
            return true;
        }
        return false;
    }

    public static boolean onEnemyInk(World worldIn, EntityPlayer playerIn) {
        return SplatCraftUtils.onEnemyInk(worldIn, playerIn, 0.1);
    }

    public static boolean onEnemyInk(World worldIn, EntityPlayer playerIn, double offset) {
        BlockPos pos = new BlockPos(playerIn.field_70165_t, playerIn.field_70163_u - offset, playerIn.field_70161_v);
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        if ((!(block instanceof IInked) || block instanceof IInked && ((IInked)block).canDamage()) && worldIn.func_175625_s(pos) instanceof TileEntityColor) {
            return !SplatCraftGamerules.getGameruleValue("universalInk") && ((TileEntityColor)worldIn.func_175625_s(pos)).getColor() != SplatCraftPlayerData.getInkColor(playerIn) && !playerIn.func_184218_aH();
        }
        return false;
    }

    public static void createInkExplosion(World worldIn, Entity source, BlockPos pos, float radius, float damage, int color, boolean isGlowing) {
        if (!worldIn.field_72995_K) {
            InkExplosion explosion = new InkExplosion(worldIn, source, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), radius, color, damage, true).setInkType(isGlowing);
            explosion.doExplosionA();
            explosion.doExplosionB(true);
        }
    }

    public static boolean playerInkBlock(EntityPlayer player, World worldIn, BlockPos pos, int color, float damage, boolean isGlowing) {
        if (SplatCraftUtils.inkBlock(worldIn, pos, color, damage, isGlowing)) {
            player.func_71029_a(SplatCraftStats.BLOCKS_INKED);
            return true;
        }
        return false;
    }

    public static boolean inkBlock(World worldIn, BlockPos pos, int color, float damage) {
        return SplatCraftUtils.inkBlock(worldIn, pos, color, damage, false);
    }

    public static boolean inkBlock(World worldIn, BlockPos pos, int color, float damage, boolean isGlowing) {
        Block inkBlock = isGlowing ? SplatCraftBlocks.glowingInkedBlock : SplatCraftBlocks.inkedBlock;
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150425_aM || state.func_177230_c() == Blocks.field_150379_bu || state.func_177230_c() == Blocks.field_150374_bv) {
            return false;
        }
        if (state.func_177230_c() != Blocks.field_180401_cv) {
            if (IInked.touchingWater(worldIn, pos)) {
                return false;
            }
            if (worldIn.func_175625_s(pos) instanceof TileEntityStageBarrier) {
                TileEntityStageBarrier te = (TileEntityStageBarrier)worldIn.func_175625_s(pos);
                te.resetActiveTime();
                return false;
            }
            if (worldIn.func_175625_s(pos) instanceof TileEntitySunkenCrate) {
                TileEntitySunkenCrate te = (TileEntitySunkenCrate)worldIn.func_175625_s(pos);
                te.ink(color, (int)Math.floor(damage));
                worldIn.func_184138_a(pos, state, state, 3);
                return true;
            }
            if (worldIn.func_175625_s(pos) instanceof TileEntityColor) {
                TileEntityColor te = (TileEntityColor)worldIn.func_175625_s(pos);
                if (state.func_177230_c() instanceof BlockInkedWool) {
                    worldIn.func_175656_a(pos, inkBlock.func_176223_P());
                    TileEntityInkedBlock inkTe = (TileEntityInkedBlock)inkBlock.createTileEntity(worldIn, inkBlock.func_176223_P());
                    worldIn.func_175690_a(pos, (TileEntity)inkTe);
                    inkTe.setColor(color);
                    inkTe.setSavedColor(te.getColor());
                    inkTe.setSavedState(state);
                    return true;
                }
                if (state.func_177230_c() instanceof IInked && !((IInked)state.func_177230_c()).canInk()) {
                    return false;
                }
                if (state.func_177230_c() instanceof BlockInkedStairs) {
                    Block block = inkBlock = isGlowing ? SplatCraftBlocks.glowingInkedStairs : SplatCraftBlocks.inkedStairs;
                }
                if (state.func_177230_c() instanceof BlockInkedSlab) {
                    Block block = inkBlock = isGlowing ? SplatCraftBlocks.glowingInkedSlab : SplatCraftBlocks.inkedSlab;
                }
                if (te instanceof TileEntityInkedBlock && state.func_177230_c() != inkBlock) {
                    if (state.func_177230_c() instanceof BlockInkedStairs) {
                        worldIn.func_175656_a(pos, inkBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)).func_177226_a((IProperty)BlockStairs.field_176310_M, state.func_177229_b((IProperty)BlockStairs.field_176310_M)).func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)));
                    } else if (state.func_177230_c() instanceof BlockInkedSlab) {
                        worldIn.func_175656_a(pos, inkBlock.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)));
                    } else {
                        worldIn.func_175656_a(pos, inkBlock.func_176223_P());
                    }
                    TileEntityInkedBlock inkTe = (TileEntityInkedBlock)inkBlock.createTileEntity(worldIn, inkBlock.func_176223_P());
                    worldIn.func_175690_a(pos, (TileEntity)inkTe);
                    inkTe.setColor(color);
                    inkTe.setSavedState(((TileEntityInkedBlock)te).getSavedState());
                    return true;
                }
                if (te.getColor() == color) {
                    return false;
                }
                te.setColor(color);
                worldIn.func_184138_a(pos, state, state, 3);
                return true;
            }
            if (state.func_177230_c() instanceof BlockSlab && !((BlockSlab)state.func_177230_c()).func_176552_j()) {
                inkBlock = isGlowing ? SplatCraftBlocks.glowingInkedSlab : SplatCraftBlocks.inkedSlab;
                worldIn.func_175656_a(pos, inkBlock.func_176223_P().func_177226_a((IProperty)BlockSlab.field_176554_a, state.func_177229_b((IProperty)BlockSlab.field_176554_a)));
                TileEntityInkedBlock te = (TileEntityInkedBlock)inkBlock.createTileEntity(worldIn, inkBlock.func_176223_P());
                worldIn.func_175690_a(pos, (TileEntity)te);
                te.setColor(color);
                te.setSavedState(state);
                return true;
            }
            if (state.func_177230_c() instanceof BlockStairs) {
                inkBlock = isGlowing ? SplatCraftBlocks.glowingInkedStairs : SplatCraftBlocks.inkedStairs;
                worldIn.func_175656_a(pos, inkBlock.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176308_b, state.func_177229_b((IProperty)BlockStairs.field_176308_b)).func_177226_a((IProperty)BlockStairs.field_176310_M, state.func_177229_b((IProperty)BlockStairs.field_176310_M)).func_177226_a((IProperty)BlockStairs.field_176309_a, state.func_177229_b((IProperty)BlockStairs.field_176309_a)));
                TileEntityInkedBlock te = (TileEntityInkedBlock)inkBlock.createTileEntity(worldIn, inkBlock.func_176223_P());
                worldIn.func_175690_a(pos, (TileEntity)te);
                te.setColor(color);
                te.setSavedState(state);
                return true;
            }
            if (!state.func_185913_b() || !state.func_185914_p() && !(state.func_177230_c() instanceof BlockLeaves)) {
                return false;
            }
            if (worldIn.func_175625_s(pos) != null) {
                return false;
            }
        }
        worldIn.func_175656_a(pos, inkBlock.func_176223_P());
        TileEntityInkedBlock te = (TileEntityInkedBlock)inkBlock.createTileEntity(worldIn, inkBlock.func_176223_P());
        worldIn.func_175690_a(pos, (TileEntity)te);
        te.setColor(color);
        te.setSavedState(state);
        return true;
    }

    public static boolean canInkPassthrough(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_150350_a || state.func_177230_c() == Blocks.field_150411_aY || state.func_177230_c() instanceof BlockSquidPassable) {
            return true;
        }
        if (!state.func_185904_a().func_76230_c()) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockSCBarrier || state.func_177230_c() == Blocks.field_180401_cv || state.func_177230_c() instanceof BlockSlab || state.func_177230_c() instanceof BlockStairs) {
            return false;
        }
        return !state.func_185913_b() && state.func_185887_b(worldIn, pos) == -1.0f;
    }

    public static boolean canInk(World worldIn, BlockPos pos) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() == Blocks.field_180401_cv) {
            return true;
        }
        if (state.func_177230_c() == Blocks.field_150425_aM || state.func_177230_c() == Blocks.field_150379_bu || state.func_177230_c() == Blocks.field_150374_bv) {
            return false;
        }
        if (state.func_177230_c() instanceof BlockSlab || state.func_177230_c() instanceof BlockStairs) {
            return true;
        }
        if (!state.func_185913_b() || !state.func_185914_p() && !(state.func_177230_c() instanceof BlockLeaves) || IInked.touchingWater(worldIn, pos)) {
            return false;
        }
        if (worldIn.func_175625_s(pos) instanceof TileEntitySunkenCrate) {
            return true;
        }
        if (state.func_177230_c() instanceof BlockInkedWool) {
            return true;
        }
        if (worldIn.func_175625_s(pos) instanceof TileEntityColor) {
            return !(state.func_177230_c() instanceof BlockInkColor) || ((BlockInkColor)state.func_177230_c()).canInk;
        }
        return worldIn.func_175625_s(pos) == null;
    }

    public static String getColorName(int color) {
        InkColors col = InkColors.getByColor(color);
        if (col == null) {
            String fallbackName = "color." + String.format("%06X", color).toUpperCase();
            String fallbackNameLocalized = I18n.func_74838_a((String)fallbackName);
            return fallbackNameLocalized.equals(fallbackName) ? String.format("#%06X", color) : fallbackNameLocalized;
        }
        return I18n.func_74838_a((String)("color." + col.getName()));
    }

    public static String getUnlocColorName(int color, boolean useHash) {
        InkColors col = InkColors.getByColor(color);
        if (col == null) {
            return String.format((useHash ? "#" : "") + "%06X", color).toLowerCase();
        }
        return col.getName();
    }

    public static String getUnlocColorName(int color) {
        return SplatCraftUtils.getUnlocColorName(color, false);
    }

    public static void dropItem(World worldIn, BlockPos pos, ItemStack stack, boolean useTileDrops) {
        boolean doTileDrops;
        boolean bl = doTileDrops = useTileDrops ? worldIn.func_82736_K().func_82766_b("doTileDrops") : true;
        if (!worldIn.field_72995_K && !stack.func_190926_b() && doTileDrops && !worldIn.restoringBlockSnapshots) {
            float f = 0.5f;
            double d0 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d1 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            double d2 = (double)(worldIn.field_73012_v.nextFloat() * 0.5f) + 0.25;
            EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, stack);
            entityitem.func_174869_p();
            worldIn.func_72838_d((Entity)entityitem);
        }
    }

    public static void giveItem(EntityPlayer reciever, ItemStack stack) {
        if (!reciever.func_191521_c(stack)) {
            EntityItem entity = reciever.func_71019_a(stack, false);
            if (entity != null) {
                entity.func_174868_q();
            }
        } else {
            reciever.field_71069_bz.func_75142_b();
        }
    }

    public static ItemStack getSilkTouchDropFromBlock(Block block, IBlockState state) {
        Item item = Item.func_150898_a((Block)block);
        int i = 0;
        if (item.func_77614_k()) {
            i = block.func_176201_c(state);
        }
        return new ItemStack(item, 1, i);
    }

    public static RayTraceResult rayTraceBlocks(World worldIn, Vec3d vecStart, Vec3d vecEnd) {
        boolean stopOnLiquid = true;
        boolean ignoreBlockWithoutBoundingBox = true;
        boolean returnLastUncollidableBlock = false;
        if (!(Double.isNaN(vecStart.field_72450_a) || Double.isNaN(vecStart.field_72448_b) || Double.isNaN(vecStart.field_72449_c))) {
            if (!(Double.isNaN(vecEnd.field_72450_a) || Double.isNaN(vecEnd.field_72448_b) || Double.isNaN(vecEnd.field_72449_c))) {
                RayTraceResult raytraceresult;
                int i = MathHelper.func_76128_c((double)vecEnd.field_72450_a);
                int j = MathHelper.func_76128_c((double)vecEnd.field_72448_b);
                int k = MathHelper.func_76128_c((double)vecEnd.field_72449_c);
                int l = MathHelper.func_76128_c((double)vecStart.field_72450_a);
                int i1 = MathHelper.func_76128_c((double)vecStart.field_72448_b);
                int j1 = MathHelper.func_76128_c((double)vecStart.field_72449_c);
                BlockPos blockpos = new BlockPos(l, i1, j1);
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                Block block = iblockstate.func_177230_c();
                if (!(SplatCraftUtils.canInkPassthrough(worldIn, blockpos) || ignoreBlockWithoutBoundingBox && iblockstate.func_185890_d((IBlockAccess)worldIn, blockpos) == Block.field_185506_k || !block.func_176209_a(iblockstate, stopOnLiquid) || (raytraceresult = iblockstate.func_185910_a(worldIn, blockpos, vecStart, vecEnd)) == null)) {
                    return raytraceresult;
                }
                RayTraceResult raytraceresult2 = null;
                int k1 = 200;
                while (k1-- >= 0) {
                    EnumFacing enumfacing;
                    if (Double.isNaN(vecStart.field_72450_a) || Double.isNaN(vecStart.field_72448_b) || Double.isNaN(vecStart.field_72449_c)) {
                        return null;
                    }
                    if (l == i && i1 == j && j1 == k) {
                        return returnLastUncollidableBlock ? raytraceresult2 : null;
                    }
                    boolean flag2 = true;
                    boolean flag = true;
                    boolean flag1 = true;
                    double d0 = 999.0;
                    double d1 = 999.0;
                    double d2 = 999.0;
                    if (i > l) {
                        d0 = (double)l + 1.0;
                    } else if (i < l) {
                        d0 = (double)l + 0.0;
                    } else {
                        flag2 = false;
                    }
                    if (j > i1) {
                        d1 = (double)i1 + 1.0;
                    } else if (j < i1) {
                        d1 = (double)i1 + 0.0;
                    } else {
                        flag = false;
                    }
                    if (k > j1) {
                        d2 = (double)j1 + 1.0;
                    } else if (k < j1) {
                        d2 = (double)j1 + 0.0;
                    } else {
                        flag1 = false;
                    }
                    double d3 = 999.0;
                    double d4 = 999.0;
                    double d5 = 999.0;
                    double d6 = vecEnd.field_72450_a - vecStart.field_72450_a;
                    double d7 = vecEnd.field_72448_b - vecStart.field_72448_b;
                    double d8 = vecEnd.field_72449_c - vecStart.field_72449_c;
                    if (flag2) {
                        d3 = (d0 - vecStart.field_72450_a) / d6;
                    }
                    if (flag) {
                        d4 = (d1 - vecStart.field_72448_b) / d7;
                    }
                    if (flag1) {
                        d5 = (d2 - vecStart.field_72449_c) / d8;
                    }
                    if (d3 == -0.0) {
                        d3 = -1.0E-4;
                    }
                    if (d4 == -0.0) {
                        d4 = -1.0E-4;
                    }
                    if (d5 == -0.0) {
                        d5 = -1.0E-4;
                    }
                    if (d3 < d4 && d3 < d5) {
                        enumfacing = i > l ? EnumFacing.WEST : EnumFacing.EAST;
                        vecStart = new Vec3d(d0, vecStart.field_72448_b + d7 * d3, vecStart.field_72449_c + d8 * d3);
                    } else if (d4 < d5) {
                        enumfacing = j > i1 ? EnumFacing.DOWN : EnumFacing.UP;
                        vecStart = new Vec3d(vecStart.field_72450_a + d6 * d4, d1, vecStart.field_72449_c + d8 * d4);
                    } else {
                        enumfacing = k > j1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        vecStart = new Vec3d(vecStart.field_72450_a + d6 * d5, vecStart.field_72448_b + d7 * d5, d2);
                    }
                    l = MathHelper.func_76128_c((double)vecStart.field_72450_a) - (enumfacing == EnumFacing.EAST ? 1 : 0);
                    i1 = MathHelper.func_76128_c((double)vecStart.field_72448_b) - (enumfacing == EnumFacing.UP ? 1 : 0);
                    j1 = MathHelper.func_76128_c((double)vecStart.field_72449_c) - (enumfacing == EnumFacing.SOUTH ? 1 : 0);
                    blockpos = new BlockPos(l, i1, j1);
                    IBlockState iblockstate1 = worldIn.func_180495_p(blockpos);
                    Block block1 = iblockstate1.func_177230_c();
                    if (ignoreBlockWithoutBoundingBox && iblockstate1.func_185904_a() != Material.field_151567_E && iblockstate1.func_185890_d((IBlockAccess)worldIn, blockpos) == Block.field_185506_k) continue;
                    if (block1.func_176209_a(iblockstate1, stopOnLiquid)) {
                        RayTraceResult raytraceresult1 = iblockstate1.func_185910_a(worldIn, blockpos, vecStart, vecEnd);
                        if (raytraceresult1 == null) continue;
                        return raytraceresult1;
                    }
                    raytraceresult2 = new RayTraceResult(RayTraceResult.Type.MISS, vecStart, enumfacing, blockpos);
                }
                return returnLastUncollidableBlock ? raytraceresult2 : null;
            }
            return null;
        }
        return null;
    }
}

