/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.world.save;

import com.cibernet.splatcraft.network.PacketUpdateGamerule;
import com.cibernet.splatcraft.network.SplatCraftPacketHandler;
import java.util.HashMap;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SplatCraftGamerules {
    public static HashMap<String, Gamerule> ruleList = new HashMap();

    public static void registerRules() {
        SplatCraftGamerules.registerGamerule(new Gamerule("inkDecay", true));
        SplatCraftGamerules.registerGamerule(new Gamerule("keepWeaponsOnDeath", false));
        SplatCraftGamerules.registerGamerule(new Gamerule("requireInkTank", true));
        SplatCraftGamerules.registerGamerule(new Gamerule("dropCrateLootWhenMined", false));
        SplatCraftGamerules.registerGamerule(new Gamerule("dealWaterDamage", false));
        SplatCraftGamerules.registerGamerule(new Gamerule("tankToTransform", false));
        SplatCraftGamerules.registerGamerule(new Gamerule("universalInk", false));
    }

    public static void registerGamerule(Gamerule rule) {
        ruleList.put(rule.getName(), rule);
    }

    public static boolean getGameruleValue(String name) {
        return ruleList.get(name).getValue();
    }

    public static void setGameruleValue(String name, boolean value) {
        ruleList.get(name).setValue(value);
        NBTTagCompound ruleNBT = new NBTTagCompound();
        SplatCraftGamerules.writeToNBT(ruleNBT);
        SplatCraftPacketHandler.instance.sendToAll((IMessage)new PacketUpdateGamerule(ruleNBT));
    }

    public static String[] getGameruleNames() {
        return ruleList.keySet().toArray(new String[ruleList.size()]);
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound ruleCompound = new NBTTagCompound();
        for (Gamerule gamerule : ruleList.values()) {
            ruleCompound.func_74757_a(gamerule.getName(), gamerule.getValue());
        }
        nbt.func_74782_a("gamerules", (NBTBase)ruleCompound);
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return;
        }
        NBTTagCompound ruleCompound = nbt.func_74775_l("gamerules");
        for (Gamerule rule : ruleList.values()) {
            if (!ruleCompound.func_74764_b(rule.getName())) {
                rule.setValue(rule.defaultValue);
                continue;
            }
            rule.setValue(ruleCompound.func_74767_n(rule.getName()));
        }
    }

    public static void resetGamerules() {
        for (Gamerule rule : ruleList.values()) {
            rule.setValue(rule.defaultValue);
        }
    }

    public static class Gamerule {
        String name;
        boolean defaultValue;
        boolean value;

        public Gamerule(String name, boolean defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }

        public String getName() {
            return this.name;
        }

        public boolean getValue() {
            return this.value;
        }

        public Gamerule setValue(boolean value) {
            this.value = value;
            return this;
        }
    }
}

