/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.world.save;

import com.cibernet.splatcraft.items.ICharge;
import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.utils.InkColors;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SplatCraftPlayerData {
    static Map<UUID, PlayerData> dataMap = new HashMap<UUID, PlayerData>();
    static Map<UUID, TempPlayerData> tempDataMap = new HashMap<UUID, TempPlayerData>();

    public static PlayerData getPlayerData(EntityPlayer playerIn) {
        Objects.requireNonNull(playerIn);
        return SplatCraftPlayerData.getPlayerData(playerIn.func_110124_au());
    }

    public static PlayerData getPlayerData(UUID uuid) {
        if (!dataMap.containsKey(uuid)) {
            PlayerData data = new PlayerData(uuid);
            dataMap.put(uuid, data);
        }
        return dataMap.get(uuid);
    }

    public static TempPlayerData getTempPlayerData(EntityPlayer playerIn) {
        Objects.requireNonNull(playerIn);
        return SplatCraftPlayerData.getTempPlayerData(playerIn.func_110124_au());
    }

    public static TempPlayerData getTempPlayerData(UUID uuid) {
        if (!tempDataMap.containsKey(uuid)) {
            TempPlayerData data = new TempPlayerData(uuid);
            tempDataMap.put(uuid, data);
        }
        return tempDataMap.get(uuid);
    }

    public static void deleteTempData(UUID uuid) {
        if (tempDataMap.containsKey(uuid)) {
            tempDataMap.remove(uuid);
        }
    }

    public static void deleteTempData() {
        tempDataMap.clear();
    }

    public static int getInkColor(EntityPlayer playerIn) {
        return SplatCraftPlayerData.getPlayerData((EntityPlayer)playerIn).inkColor;
    }

    public static boolean getIsSquid(EntityPlayer playerIn) {
        return SplatCraftPlayerData.getPlayerData((EntityPlayer)playerIn).isSquid == 2;
    }

    public static void setInkColor(EntityPlayer playerIn, int inkColor) {
        SplatCraftPlayerData.getPlayerData((EntityPlayer)playerIn).inkColor = inkColor;
        SplatcraftScoreboardHandler.updatePlayerColorScore(playerIn, inkColor);
    }

    public static void setIsSquid(EntityPlayer playerIn, boolean isSquid) {
        SplatCraftPlayerData.getPlayerData((EntityPlayer)playerIn).isSquid = isSquid ? 2 : 1;
    }

    public static boolean canDischarge(EntityPlayer player) {
        return SplatCraftPlayerData.getTempPlayerData((EntityPlayer)player).canDischarge;
    }

    public static void setCanDischarge(UUID player, boolean discharge) {
        SplatCraftPlayerData.getTempPlayerData((UUID)player).canDischarge = discharge;
    }

    public static float getWeaponCharge(EntityPlayer playerIn, ItemStack stack) {
        return SplatCraftPlayerData.getTempPlayerData((EntityPlayer)playerIn).chargedWeapon.func_77969_a(stack) ? SplatCraftPlayerData.getTempPlayerData((EntityPlayer)playerIn).charge : 0.0f;
    }

    public static float getWeaponCharge(UUID playerIn, ItemStack stack) {
        return SplatCraftPlayerData.getTempPlayerData((UUID)playerIn).chargedWeapon.func_77969_a(stack) ? SplatCraftPlayerData.getTempPlayerData((UUID)playerIn).charge : 0.0f;
    }

    public static void setWeaponCharge(EntityPlayer playerIn, ItemStack stack, float charge) {
        SplatCraftPlayerData.setWeaponCharge(playerIn.func_110124_au(), stack, charge);
    }

    public static void setWeaponCharge(UUID playerIn, ItemStack stack, float charge) {
        TempPlayerData data = SplatCraftPlayerData.getTempPlayerData(playerIn);
        data.charge = charge;
        data.chargedWeapon = stack;
    }

    public static void addWeaponCharge(EntityPlayer playerIn, ItemStack stack, float add) {
        if (!playerIn.field_70170_p.field_72995_K) {
            return;
        }
        TempPlayerData data = SplatCraftPlayerData.getTempPlayerData(playerIn);
        if (data.chargedWeapon.func_77969_a(stack)) {
            data.charge = Math.max(0.0f, Math.min(data.charge + add, 1.0f));
        } else {
            data.charge = Math.max(0.0f, add);
            data.chargedWeapon = stack;
        }
    }

    public static void dischargeWeapon(EntityPlayer player) {
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        TempPlayerData data = SplatCraftPlayerData.getTempPlayerData(player);
        Item item = data.chargedWeapon.func_77973_b();
        data.charge = item instanceof ICharge ? Math.max(0.0f, data.charge - ((ICharge)item).getDischargeSpeed()) : 0.0f;
    }

    public static void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (PlayerData data : dataMap.values()) {
            list.func_74742_a((NBTBase)data.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("playerData", (NBTBase)list);
    }

    public static void readFromNBT(NBTTagCompound nbt) {
        dataMap.clear();
        if (nbt != null) {
            NBTTagList list = nbt.func_150295_c("playerData", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound dataCompound = list.func_150305_b(i);
                PlayerData data = new PlayerData();
                data.readFromNBT(dataCompound);
                dataMap.put(data.player, data);
            }
        }
    }

    public static class TempPlayerData {
        public UUID player;
        public ItemStack chargedWeapon = ItemStack.field_190927_a;
        public float charge = 0.0f;
        public boolean canDischarge = false;

        public TempPlayerData(UUID uuid) {
            this.player = uuid;
        }

        public TempPlayerData() {
        }
    }

    public static class PlayerData {
        public UUID player;
        public int inkColor = InkColors.getRandomStarterColor().getColor();
        public int isSquid = 0;

        public PlayerData(UUID uuid) {
            this.player = uuid;
        }

        public PlayerData() {
        }

        private void readFromNBT(NBTTagCompound nbt) {
            if (!nbt.func_186855_b("uuid")) {
                return;
            }
            this.player = nbt.func_186857_a("uuid");
            if (nbt.func_74764_b("inkColor")) {
                this.inkColor = nbt.func_74762_e("inkColor");
            }
            if (nbt.func_74764_b("isSquid")) {
                this.isSquid = nbt.func_74767_n("isSquid") ? 2 : 1;
            }
        }

        private NBTTagCompound writeToNBT(NBTTagCompound nbt) {
            nbt.func_186854_a("uuid", this.player);
            nbt.func_74768_a("inkColor", this.inkColor);
            nbt.func_74757_a("isSquid", this.isSquid == 2);
            return nbt;
        }
    }
}

