/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.world.save;

import com.cibernet.splatcraft.scoreboard.SplatcraftScoreboardHandler;
import com.cibernet.splatcraft.world.save.SplatCraftGamerules;
import com.cibernet.splatcraft.world.save.SplatCraftPlayerData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SplatCraftSaveHandler {
    @SubscribeEvent
    public void onWorldSave(WorldEvent.Save event) {
        if (event.getWorld().field_73011_w.getDimension() != 0) {
            return;
        }
        File dataFile = event.getWorld().func_72860_G().func_75758_b("SplatCraftData");
        if (dataFile != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            SplatCraftPlayerData.writeToNBT(nbt);
            SplatCraftGamerules.writeToNBT(nbt);
            SplatcraftScoreboardHandler.writeToNBT(nbt);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)new FileOutputStream(dataFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_73011_w.getDimension() != 0 || event.getWorld().field_72995_K) {
            return;
        }
        ISaveHandler saveHandler = event.getWorld().func_72860_G();
        File dataFile = saveHandler.func_75758_b("SplatCraftData");
        if (dataFile != null && dataFile.exists()) {
            NBTTagCompound nbt = null;
            try {
                nbt = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(dataFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (nbt != null) {
                SplatCraftPlayerData.readFromNBT(nbt);
                SplatCraftGamerules.readFromNBT(nbt);
                SplatcraftScoreboardHandler.readFromNBT(nbt);
                return;
            }
        } else {
            SplatCraftGamerules.resetGamerules();
        }
        SplatCraftPlayerData.readFromNBT(null);
    }
}

