/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft;

import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import com.cibernet.splatcraft.handlers.client.ClientSetupHandler;
import com.cibernet.splatcraft.handlers.client.SplatcraftKeyHandler;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftCapabilities;
import com.cibernet.splatcraft.registries.SplatcraftCommands;
import com.cibernet.splatcraft.registries.SplatcraftEntities;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.registries.SplatcraftStats;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartedEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="splatcraft")
public class Splatcraft {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "splatcraft";
    public static final String MODNAME = "Splatcraft";
    public static final String SHORT = "SC";
    public static final String VERSION = "2.3.0";

    public Splatcraft() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        SplatcraftCapabilities.registerCapabilities();
        SplatcraftPacketHandler.registerMessages();
        DeferredWorkQueue.runLater(() -> {
            SplatcraftEntities.setEntityAttributes();
            SplatcraftGameRules.registerGamerules();
        });
        SplatcraftSounds.initSounds();
        SplatcraftTags.register();
        SplatcraftStats.register();
        ScoreboardHandler.register();
        SplatcraftCommands.registerArguments();
    }

    private void clientSetup(FMLClientSetupEvent event) {
        SplatcraftEntities.bindRenderers();
        SplatcraftKeyHandler.registerKeys();
        SplatcraftBlocks.setRenderLayers();
        SplatcraftTileEntitites.bindTESR();
        DeferredWorkQueue.runLater(() -> {
            SplatcraftItems.registerModelProperties();
            SplatcraftItems.registerArmorModels();
            ClientSetupHandler.bindScreenContainers();
        });
    }

    @SubscribeEvent
    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
    }

    @SubscribeEvent
    public void onServerStarted(FMLServerStartedEvent event) {
        for (Map.Entry<Integer, Boolean> rule : SplatcraftGameRules.booleanRules.entrySet()) {
            SplatcraftGameRules.booleanRules.put(rule.getKey(), event.getServer().func_200252_aR().func_223586_b(SplatcraftGameRules.getRuleFromIndex(rule.getKey())));
        }
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
        }
    }
}

