/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.ToolType;

public class BarrierBarBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<Half> HALF = BlockStateProperties.field_208164_Q;
    public static final EnumProperty<StairsShape> SHAPE = BlockStateProperties.field_208146_au;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    protected static final AxisAlignedBB STRAIGHT_AABB = new AxisAlignedBB(0.0, 0.8125, 0.8125, 1.0, 1.0, 1.0);
    protected static final AxisAlignedBB EDGE_AABB = new AxisAlignedBB(0.0, 0.8125, 0.8125, 0.1875, 1.0, 1.0);
    protected static final AxisAlignedBB ROTATED_STRAIGHT_AABB = BarrierBarBlock.modifyShapeForDirection(Direction.EAST, VoxelShapes.func_197881_a((AxisAlignedBB)STRAIGHT_AABB)).func_197752_a();
    protected static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.8125, 0.0, 1.0, 1.0, 1.0);
    protected static final VoxelShape NU_STRAIGHT = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape SU_STRAIGHT = BarrierBarBlock.modifyShapeForDirection(Direction.SOUTH, NU_STRAIGHT);
    protected static final VoxelShape WU_STRAIGHT = BarrierBarBlock.modifyShapeForDirection(Direction.WEST, NU_STRAIGHT);
    protected static final VoxelShape EU_STRAIGHT = BarrierBarBlock.modifyShapeForDirection(Direction.EAST, NU_STRAIGHT);
    protected static final VoxelShape ND_STRAIGHT = BarrierBarBlock.mirrorShapeY(NU_STRAIGHT);
    protected static final VoxelShape SD_STRAIGHT = BarrierBarBlock.mirrorShapeY(SU_STRAIGHT);
    protected static final VoxelShape WD_STRAIGHT = BarrierBarBlock.mirrorShapeY(WU_STRAIGHT);
    protected static final VoxelShape ED_STRAIGHT = BarrierBarBlock.mirrorShapeY(EU_STRAIGHT);
    protected static final VoxelShape NU_CORNER = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)3.0);
    protected static final VoxelShape SU_CORNER = BarrierBarBlock.modifyShapeForDirection(Direction.SOUTH, NU_CORNER);
    protected static final VoxelShape WU_CORNER = BarrierBarBlock.modifyShapeForDirection(Direction.WEST, NU_CORNER);
    protected static final VoxelShape EU_CORNER = BarrierBarBlock.modifyShapeForDirection(Direction.EAST, NU_CORNER);
    protected static final VoxelShape ND_CORNER = BarrierBarBlock.mirrorShapeY(NU_CORNER);
    protected static final VoxelShape SD_CORNER = BarrierBarBlock.mirrorShapeY(SU_CORNER);
    protected static final VoxelShape WD_CORNER = BarrierBarBlock.mirrorShapeY(WU_CORNER);
    protected static final VoxelShape ED_CORNER = BarrierBarBlock.mirrorShapeY(EU_CORNER);
    protected static final VoxelShape[] TOP_SHAPES = new VoxelShape[]{NU_STRAIGHT, SU_STRAIGHT, WU_STRAIGHT, EU_STRAIGHT, NU_CORNER, SU_CORNER, WU_CORNER, EU_CORNER};
    protected static final VoxelShape[] BOTTOM_SHAPES = new VoxelShape[]{ND_STRAIGHT, SD_STRAIGHT, WD_STRAIGHT, ED_STRAIGHT, ND_CORNER, SD_CORNER, WD_CORNER, ED_CORNER};

    public BarrierBarBlock(String name) {
        super(AbstractBlock.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151660_b).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).func_235861_h_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(HALF, (Comparable)Half.BOTTOM)).func_206870_a(SHAPE, (Comparable)StairsShape.STRAIGHT)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName(name);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        VoxelShape[] shapeArray = ((Half)state.func_177229_b(HALF)).equals((Object)Half.TOP) ? TOP_SHAPES : BOTTOM_SHAPES;
        int dirIndex = ((Direction)state.func_177229_b((Property)FACING)).ordinal() - 2;
        int rotatedDirIndex = ((Direction)state.func_177229_b((Property)FACING)).func_176746_e().ordinal() - 2;
        int rotatedCCWDirIndex = ((Direction)state.func_177229_b((Property)FACING)).func_176735_f().ordinal() - 2;
        switch ((StairsShape)state.func_177229_b(SHAPE)) {
            case STRAIGHT: {
                return shapeArray[dirIndex];
            }
            case OUTER_LEFT: {
                return shapeArray[dirIndex + 4];
            }
            case OUTER_RIGHT: {
                return BarrierBarBlock.mirrorShapeX(shapeArray[dirIndex + 4]);
            }
            case INNER_LEFT: {
                return VoxelShapes.func_197872_a((VoxelShape)shapeArray[dirIndex], (VoxelShape)shapeArray[rotatedCCWDirIndex]);
            }
            case INNER_RIGHT: {
                return VoxelShapes.func_197872_a((VoxelShape)shapeArray[dirIndex], (VoxelShape)shapeArray[rotatedDirIndex]);
            }
        }
        return Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    protected static VoxelShape modifyShapeForDirection(Direction facing, VoxelShape shape) {
        AxisAlignedBB bb = shape.func_197752_a();
        switch (facing) {
            case EAST: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d));
            }
            case SOUTH: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c));
            }
            case WEST: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a));
            }
        }
        return shape;
    }

    public static VoxelShape mirrorShapeY(VoxelShape shape) {
        AxisAlignedBB bb = shape.func_197752_a();
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(bb.field_72340_a, 1.0 - bb.field_72338_b, bb.field_72339_c, bb.field_72336_d, 1.0 - bb.field_72337_e, bb.field_72334_f));
    }

    public static VoxelShape mirrorShapeX(VoxelShape shape) {
        AxisAlignedBB bb = shape.func_197752_a();
        return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72340_a, bb.field_72338_b, bb.field_72339_c, 1.0 - bb.field_72336_d, bb.field_72337_e, bb.field_72334_f));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        BlockState blockstate = (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f())).func_206870_a(HALF, (Comparable)(!(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockpos.func_177956_o() > 0.5) ? Half.BOTTOM : Half.TOP))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
        return (BlockState)blockstate.func_206870_a(SHAPE, (Comparable)BarrierBarBlock.getShapeProperty(blockstate, (IBlockReader)context.func_195991_k(), blockpos));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176740_k().func_176722_c() ? (BlockState)stateIn.func_206870_a(SHAPE, (Comparable)BarrierBarBlock.getShapeProperty(stateIn, (IBlockReader)worldIn, currentPos)) : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (BarrierBarBlock.isBar(blockstate) && state.func_177229_b(HALF) == blockstate.func_177229_b(HALF) && (direction1 = (Direction)blockstate.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && BarrierBarBlock.isDifferentBar(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (BarrierBarBlock.isBar(blockstate1) && state.func_177229_b(HALF) == blockstate1.func_177229_b(HALF) && (direction2 = (Direction)blockstate1.func_177229_b((Property)FACING)).func_176740_k() != ((Direction)state.func_177229_b((Property)FACING)).func_176740_k() && BarrierBarBlock.isDifferentBar(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean isDifferentBar(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !BarrierBarBlock.isBar(blockstate) || blockstate.func_177229_b((Property)FACING) != state.func_177229_b((Property)FACING) || blockstate.func_177229_b(HALF) != state.func_177229_b(HALF);
    }

    public static boolean isBar(BlockState state) {
        return state.func_177230_c() instanceof BarrierBarBlock;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        StairsShape stairsshape = (StairsShape)state.func_177229_b(SHAPE);
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                if (direction.func_176740_k() != Direction.Axis.Z) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                }
                return state.func_185907_a(Rotation.CLOCKWISE_180);
            }
            case FRONT_BACK: {
                if (direction.func_176740_k() != Direction.Axis.X) break;
                switch (stairsshape) {
                    case INNER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_LEFT);
                    }
                    case INNER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.INNER_RIGHT);
                    }
                    case OUTER_LEFT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_RIGHT);
                    }
                    case OUTER_RIGHT: {
                        return (BlockState)state.func_185907_a(Rotation.CLOCKWISE_180).func_206870_a(SHAPE, (Comparable)StairsShape.OUTER_LEFT);
                    }
                    case STRAIGHT: {
                        return state.func_185907_a(Rotation.CLOCKWISE_180);
                    }
                }
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, HALF, SHAPE, WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

