/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.blocks.InkedBlock;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.util.InkBlockUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class CanvasBlock
extends Block
implements IColoredBlock {
    public static final BooleanProperty INKED = BooleanProperty.func_177716_a((String)"inked");

    public CanvasBlock(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g));
        SplatcraftBlocks.inkColoredBlocks.add(this);
        this.setRegistryName(name);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)INKED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        InkColorTileEntity te = (InkColorTileEntity)SplatcraftTileEntitites.colorTileEntity.func_200968_a();
        te.setColor(-1);
        return te;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{INKED});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        int color = this.getColor((World)worldIn, currentPos);
        if (InkedBlock.isTouchingLiquid((IBlockReader)worldIn, currentPos) && worldIn.func_175625_s(currentPos) instanceof InkColorTileEntity) {
            ((InkColorTileEntity)worldIn.func_175625_s(currentPos)).setColor(-1);
        }
        return (BlockState)super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos).func_206870_a((Property)INKED, (Comparable)Boolean.valueOf(color != -1));
    }

    private static BlockState clearInk(IWorld world, BlockPos pos) {
        InkedBlockTileEntity te = (InkedBlockTileEntity)world.func_175625_s(pos);
        if (te.hasSavedState()) {
            world.func_180501_a(pos, te.getSavedState(), 3);
            if (te.hasSavedColor() && te.getSavedState().func_177230_c() instanceof IColoredBlock) {
                ((World)world).func_175690_a(pos, te.getSavedState().func_177230_c().createTileEntity(te.getSavedState(), (IBlockReader)world));
                if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
                    InkColorTileEntity newte = (InkColorTileEntity)world.func_175625_s(pos);
                    newte.setColor(te.getSavedColor());
                }
            }
            return te.getSavedState();
        }
        return world.func_180495_p(pos);
    }

    @Override
    public boolean inkBlock(World world, BlockPos pos, int color, float damage, InkBlockUtils.InkType inkType) {
        if (InkedBlock.isTouchingLiquid((IBlockReader)world, pos)) {
            return false;
        }
        if (color == this.getColor(world, pos)) {
            return false;
        }
        if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
            BlockState state = world.func_180495_p(pos);
            ((InkColorTileEntity)world.func_175625_s(pos)).setColor(color);
            world.func_184138_a(pos, state, (BlockState)state.func_206870_a((Property)INKED, (Comparable)Boolean.valueOf(true)), 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean canSwim() {
        return true;
    }

    @Override
    public boolean canDamage() {
        return false;
    }

    @Override
    public boolean remoteColorChange(World world, BlockPos pos, int newColor) {
        BlockState state = world.func_180495_p(pos);
        if (world.func_175625_s(pos) instanceof InkColorTileEntity && ((InkColorTileEntity)world.func_175625_s(pos)).getColor() != newColor) {
            ((InkColorTileEntity)world.func_175625_s(pos)).setColor(newColor);
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)INKED, (Comparable)Boolean.valueOf(true)), 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean remoteInkClear(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean countsTowardsTurf(World world, BlockPos pos) {
        return false;
    }
}

