/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.CrateTileEntity;
import com.cibernet.splatcraft.util.InkBlockUtils;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class CrateBlock
extends Block
implements IColoredBlock {
    public static final IntegerProperty STATE = IntegerProperty.func_177719_a((String)"state", (int)0, (int)4);
    public static final ResourceLocation STORAGE_SUNKEN_CRATE = new ResourceLocation("splatcraft", "storage/sunken_crate");
    public final boolean hasLoot;

    public CrateBlock(String name, boolean hasLoot) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).harvestTool(ToolType.AXE).func_235861_h_().func_200947_a(SoundType.field_185848_a).func_200943_b(2.0f));
        this.setRegistryName(name);
        this.hasLoot = hasLoot;
        SplatcraftBlocks.inkColoredBlocks.add(this);
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT compoundnbt = stack.func_179543_a("BlockEntityTag");
        if (compoundnbt != null && !this.hasLoot && compoundnbt.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compoundnbt, (NonNullList)nonnulllist);
            int i = 0;
            int j = 0;
            for (ItemStack itemstack : nonnulllist) {
                if (itemstack.func_190926_b()) continue;
                ++j;
                if (i > 4) continue;
                ++i;
                IFormattableTextComponent iformattabletextcomponent = itemstack.func_200301_q().func_230532_e_();
                iformattabletextcomponent.func_240702_b_(" x").func_240702_b_(String.valueOf(itemstack.func_190916_E()));
                tooltip.add((ITextComponent)iformattabletextcomponent);
            }
            if (j - i > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("container.shulkerBox.more", new Object[]{j - i}).func_240699_a_(TextFormatting.ITALIC));
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{STATE});
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (worldIn.func_175625_s(currentPos) instanceof CrateTileEntity) {
            return (BlockState)stateIn.func_206870_a((Property)STATE, (Comparable)Integer.valueOf(((CrateTileEntity)worldIn.func_175625_s(currentPos)).getState()));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        CrateTileEntity te = (CrateTileEntity)SplatcraftTileEntitites.crateTileEntity.func_200968_a();
        te.setMaxHealth(this.hasLoot ? 25.0f : 20.0f);
        te.resetHealth();
        te.setHasLoot(this.hasLoot);
        te.setColor(-1);
        return te;
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(state, worldIn, pos, oldState, isMoving);
    }

    public static List<ItemStack> generateLoot(World world, BlockPos pos, BlockState state, float luckValue) {
        if (world == null || world.field_72995_K) {
            return Collections.emptyList();
        }
        LootContext.Builder contextBuilder = new LootContext.Builder((ServerWorld)world);
        List loot = world.func_73046_m().func_200249_aQ().func_186521_a(STORAGE_SUNKEN_CRATE).func_216113_a(contextBuilder.func_186469_a(luckValue).func_216015_a(LootParameters.field_216287_g, (Object)state).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216015_a(LootParameters.field_237457_g_, (Object)new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_216022_a(LootParameterSets.field_216267_h));
        return loot;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        player.func_71029_a(Stats.field_188065_ae.func_199076_b((Object)this));
        player.func_71020_j(0.005f);
        if (worldIn.func_82736_K().func_223586_b(SplatcraftGameRules.DROP_CRATE_LOOT) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) <= 0 && worldIn.func_175625_s(pos) instanceof CrateTileEntity) {
            ((CrateTileEntity)worldIn.func_175625_s(pos)).dropInventory();
        } else {
            CrateBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)te, (Entity)player, (ItemStack)stack);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        ItemStack tool = (ItemStack)builder.func_216019_b(LootParameters.field_216289_i);
        ServerWorld world = builder.func_216018_a();
        TileEntity te = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (te instanceof CrateTileEntity) {
            boolean silkTouched;
            CrateTileEntity crate = (CrateTileEntity)te;
            boolean bl = silkTouched = tool != null && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)tool) > 0;
            if (world.func_82736_K().func_223586_b(SplatcraftGameRules.DROP_CRATE_LOOT) && !silkTouched) {
                return crate.getDrops();
            }
        }
        return super.func_220076_a(state, builder);
    }

    @Override
    public boolean inkBlock(World world, BlockPos pos, int color, float damage, InkBlockUtils.InkType inkType) {
        if (world.func_175625_s(pos) instanceof CrateTileEntity) {
            ((CrateTileEntity)world.func_175625_s(pos)).ink(color, damage);
        }
        return false;
    }

    @Override
    public boolean canClimb() {
        return false;
    }

    @Override
    public boolean canSwim() {
        return false;
    }

    @Override
    public boolean canDamage() {
        return false;
    }

    @Override
    public boolean remoteColorChange(World world, BlockPos pos, int newColor) {
        return false;
    }

    @Override
    public boolean remoteInkClear(World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof CrateTileEntity) {
            CrateTileEntity crate = (CrateTileEntity)world.func_175625_s(pos);
            if (crate.getHealth() == crate.getMaxHealth()) {
                return false;
            }
            crate.resetHealth();
            world.func_180501_a(pos, (BlockState)crate.func_195044_w().func_206870_a((Property)STATE, (Comparable)Integer.valueOf(crate.getState())), 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean countsTowardsTurf(World world, BlockPos pos) {
        return false;
    }
}

