/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.AbstractSquidPassthroughBlock;
import com.cibernet.splatcraft.blocks.GrateBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;

public class GrateRampBlock
extends AbstractSquidPassthroughBlock {
    private static final VoxelShape START = GrateRampBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)3.0, (double)16.0);
    private static final VoxelShape END = GrateRampBlock.func_208617_a((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SEGMENT = GrateRampBlock.func_208617_a((double)1.0, (double)2.0, (double)0.0, (double)4.0, (double)5.0, (double)16.0);
    public static final VoxelShape[] SHAPES = GrateRampBlock.makeVoxelShape(START, END, SEGMENT);
    public static final EnumProperty<Direction> FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public GrateRampBlock(String name) {
        super(GrateBlock.PROPERTIES);
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b(FACING)).ordinal() - 2];
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockPos = context.func_195995_a();
        Direction direction = context.func_196000_l();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockPos);
        boolean flip = !(direction == Direction.DOWN || direction != Direction.UP && context.func_221532_j().field_72448_b - (double)blockPos.func_177956_o() > 0.5);
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)(flip ? context.func_195992_f().func_176734_d() : context.func_195992_f()))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    private static VoxelShape[] makeVoxelShape(VoxelShape start, VoxelShape end, VoxelShape segment) {
        VoxelShape[] shapes = new VoxelShape[8];
        for (int i = 0; i < 6; ++i) {
            shapes[i] = segment.func_197751_a(0.125 * (double)i, 0.125 * (double)i, 0.0);
        }
        shapes[6] = start;
        shapes[7] = end;
        return GrateRampBlock.createVoxelShapes(shapes);
    }

    protected static VoxelShape modifyShapeForDirection(Direction facing, VoxelShape shape) {
        AxisAlignedBB bb = shape.func_197752_a();
        switch (facing) {
            case SOUTH: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d));
            }
            case EAST: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c));
            }
            case WEST: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a));
            }
        }
        return shape;
    }

    protected static VoxelShape[] createVoxelShapes(VoxelShape ... shapes) {
        VoxelShape[] result = new VoxelShape[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = VoxelShapes.func_197880_a();
            for (int j = 0; j < shapes.length; ++j) {
                result[i] = VoxelShapes.func_197872_a((VoxelShape)result[i], (VoxelShape)GrateRampBlock.modifyShapeForDirection(Direction.func_176731_b((int)i), shapes[j]));
            }
        }
        return result;
    }
}

