/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.util.InkBlockUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ToolType;

public class InkedBlock
extends Block
implements IColoredBlock {
    public static final AbstractBlock.Properties DEFAULT_PROPERTIES = AbstractBlock.Properties.func_200949_a((Material)Material.field_151571_B, (MaterialColor)MaterialColor.field_193560_ab).func_200944_c().harvestTool(ToolType.PICKAXE).func_235861_h_().func_200947_a(SoundType.field_185859_l);
    public static final int GLOWING_LIGHT_LEVEL = 6;

    public InkedBlock(String name) {
        this(name, DEFAULT_PROPERTIES);
    }

    public InkedBlock(String name, AbstractBlock.Properties properties) {
        super(properties);
        SplatcraftBlocks.inkColoredBlocks.add(this);
        this.setRegistryName(name);
    }

    public static InkedBlock glowing(String name) {
        return new InkedBlock(name, DEFAULT_PROPERTIES.func_235838_a_(state -> 6));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (world.func_175625_s(pos) instanceof InkedBlockTileEntity) {
            BlockState savedState = ((InkedBlockTileEntity)world.func_175625_s(pos)).getSavedState();
            return savedState.func_177230_c().getPickBlock(savedState, target, world, pos, player);
        }
        return ItemStack.field_190927_a;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof InkedBlockTileEntity)) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        InkedBlockTileEntity te = (InkedBlockTileEntity)worldIn.func_175625_s(pos);
        if (te.getSavedState().func_177230_c() instanceof InkedBlock) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        return te.getSavedState().func_177230_c().func_180647_a(te.getSavedState(), player, worldIn, pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public float func_226892_n_() {
        return super.func_226892_n_();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.func_82736_K().func_223586_b(SplatcraftGameRules.INK_DECAY) && world.func_175625_s(pos) instanceof InkedBlockTileEntity) {
            InkedBlock.clearInk((IWorld)world, pos);
        }
    }

    public static boolean isTouchingLiquid(IBlockReader reader, BlockPos pos) {
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = pos.func_239590_i_();
        BlockState currentState = reader.func_180495_p(pos);
        if (currentState.func_235901_b_((Property)BlockStateProperties.field_208198_y) && ((Boolean)currentState.func_177229_b((Property)BlockStateProperties.field_208198_y)).booleanValue()) {
            return true;
        }
        for (Direction direction : Direction.values()) {
            BlockState blockstate = reader.func_180495_p((BlockPos)blockpos$mutable);
            if (direction == Direction.DOWN && !InkedBlock.causesClear(blockstate)) continue;
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction);
            blockstate = reader.func_180495_p((BlockPos)blockpos$mutable);
            if (!InkedBlock.causesClear(blockstate) || blockstate.func_224755_d(reader, pos, direction.func_176734_d())) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public static boolean causesClear(BlockState state) {
        return state.func_204520_s().func_206884_a((ITag)FluidTags.field_206959_a);
    }

    private static BlockState clearInk(IWorld world, BlockPos pos) {
        InkedBlockTileEntity te = (InkedBlockTileEntity)world.func_175625_s(pos);
        if (te.hasSavedState()) {
            world.func_180501_a(pos, te.getSavedState(), 3);
            if (te.hasSavedColor() && te.getSavedState().func_177230_c() instanceof IColoredBlock) {
                ((World)world).func_175690_a(pos, te.getSavedState().func_177230_c().createTileEntity(te.getSavedState(), (IBlockReader)world));
                if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
                    InkColorTileEntity newte = (InkColorTileEntity)world.func_175625_s(pos);
                    newte.setColor(te.getSavedColor());
                }
            }
            return te.getSavedState();
        }
        return world.func_180495_p(pos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        BlockState savedState;
        if (InkedBlock.isTouchingLiquid((IBlockReader)worldIn, currentPos) && worldIn.func_175625_s(currentPos) instanceof InkedBlockTileEntity) {
            return InkedBlock.clearInk(worldIn, currentPos);
        }
        if (worldIn.func_175625_s(currentPos) instanceof InkedBlockTileEntity && (savedState = ((InkedBlockTileEntity)worldIn.func_175625_s(currentPos)).getSavedState()) != null && !savedState.func_177230_c().equals(this)) {
            ((InkedBlockTileEntity)worldIn.func_175625_s(currentPos)).setSavedState(savedState.func_177230_c().func_196271_a(savedState, facing, facingState, worldIn, currentPos, facingPos));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return SplatcraftTileEntitites.inkedTileEntity.func_200968_a();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean canSwim() {
        return true;
    }

    @Override
    public boolean canDamage() {
        return true;
    }

    @Override
    public int getColor(World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
            return ((InkColorTileEntity)world.func_175625_s(pos)).getColor();
        }
        return -1;
    }

    @Override
    public boolean remoteColorChange(World world, BlockPos pos, int newColor) {
        return false;
    }

    @Override
    public boolean remoteInkClear(World world, BlockPos pos) {
        BlockState oldState = world.func_180495_p(pos);
        if (world.func_175625_s(pos) instanceof InkedBlockTileEntity) {
            return !InkedBlock.clearInk((IWorld)world, pos).equals(oldState);
        }
        return false;
    }

    @Override
    public boolean countsTowardsTurf(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean inkBlock(World world, BlockPos pos, int color, float damage, InkBlockUtils.InkType inkType) {
        if (!(world.func_175625_s(pos) instanceof InkedBlockTileEntity)) {
            return false;
        }
        InkedBlockTileEntity te = (InkedBlockTileEntity)world.func_175625_s(pos);
        BlockState oldState = world.func_180495_p(pos);
        BlockState state = world.func_180495_p(pos);
        if (te.getColor() != color) {
            te.setColor(color);
        }
        if (InkBlockUtils.getInkBlock(inkType, state.func_177230_c()) != state.func_177230_c()) {
            state = InkBlockUtils.getInkState(inkType, state);
            world.func_180501_a(pos, state, 2);
            InkedBlockTileEntity newTe = (InkedBlockTileEntity)world.func_175625_s(pos);
            newTe.setSavedState(te.getSavedState());
            newTe.setColor(te.getColor());
            world.func_175690_a(pos, (TileEntity)newTe);
        } else {
            world.func_184138_a(pos, oldState, state, 2);
        }
        return te.getColor() != color || InkBlockUtils.getInkBlock(inkType, state.func_177230_c()) != state.func_177230_c();
    }
}

