/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.blocks.InkedBlock;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.util.InkBlockUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SlabBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class InkedSlabBlock
extends SlabBlock
implements IColoredBlock {
    public InkedSlabBlock(String name) {
        this(name, InkedBlock.DEFAULT_PROPERTIES);
    }

    public InkedSlabBlock(String name, AbstractBlock.Properties properties) {
        super(properties);
        SplatcraftBlocks.inkColoredBlocks.add((Block)this);
        this.setRegistryName(name);
    }

    public static InkedSlabBlock glowing(String name) {
        return new InkedSlabBlock(name, InkedBlock.DEFAULT_PROPERTIES.func_235838_a_(state -> 6));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        if (world.func_175625_s(pos) instanceof InkedBlockTileEntity) {
            BlockState savedState = ((InkedBlockTileEntity)world.func_175625_s(pos)).getSavedState();
            return savedState.func_177230_c().getPickBlock(savedState, target, world, pos, player);
        }
        return ItemStack.field_190927_a;
    }

    public float func_180647_a(BlockState state, PlayerEntity player, IBlockReader worldIn, BlockPos pos) {
        if (!(worldIn.func_175625_s(pos) instanceof InkedBlockTileEntity)) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        InkedBlockTileEntity te = (InkedBlockTileEntity)worldIn.func_175625_s(pos);
        if (te.getSavedState().func_177230_c() instanceof InkedBlock) {
            return super.func_180647_a(state, player, worldIn, pos);
        }
        return te.getSavedState().func_177230_c().func_180647_a(te.getSavedState(), player, worldIn, pos);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public float func_226892_n_() {
        return super.func_226892_n_();
    }

    public void func_225542_b_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.func_82736_K().func_223586_b(SplatcraftGameRules.INK_DECAY) && world.func_175625_s(pos) instanceof InkedBlockTileEntity) {
            InkedSlabBlock.clearInk((IWorld)world, pos);
        }
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (InkedBlock.isTouchingLiquid((IBlockReader)worldIn, currentPos) && worldIn.func_175625_s(currentPos) instanceof InkedBlockTileEntity) {
            return InkedSlabBlock.clearInk(worldIn, currentPos);
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    private static BlockState clearInk(IWorld world, BlockPos pos) {
        InkedBlockTileEntity te = (InkedBlockTileEntity)world.func_175625_s(pos);
        if (te.hasSavedState()) {
            world.func_180501_a(pos, te.getSavedState(), 3);
            if (te.hasSavedColor() && te.getSavedState().func_177230_c() instanceof IColoredBlock) {
                ((World)world).func_175690_a(pos, te.getSavedState().func_177230_c().createTileEntity(te.getSavedState(), (IBlockReader)world));
                if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
                    InkColorTileEntity newte = (InkColorTileEntity)world.func_175625_s(pos);
                    newte.setColor(te.getSavedColor());
                }
            }
            return te.getSavedState();
        }
        return world.func_180495_p(pos);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return SplatcraftTileEntitites.inkedTileEntity.func_200968_a();
    }

    @Override
    public boolean canClimb() {
        return true;
    }

    @Override
    public boolean canSwim() {
        return true;
    }

    @Override
    public boolean canDamage() {
        return true;
    }

    @Override
    public int getColor(World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
            return ((InkColorTileEntity)world.func_175625_s(pos)).getColor();
        }
        return -1;
    }

    @Override
    public boolean remoteColorChange(World world, BlockPos pos, int newColor) {
        return false;
    }

    @Override
    public boolean remoteInkClear(World world, BlockPos pos) {
        BlockState oldState = world.func_180495_p(pos);
        if (world.func_175625_s(pos) instanceof InkedBlockTileEntity) {
            return !InkedSlabBlock.clearInk((IWorld)world, pos).equals(oldState);
        }
        return false;
    }

    @Override
    public boolean countsTowardsTurf(World world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean inkBlock(World world, BlockPos pos, int color, float damage, InkBlockUtils.InkType inkType) {
        if (!(world.func_175625_s(pos) instanceof InkedBlockTileEntity)) {
            return false;
        }
        InkedBlockTileEntity te = (InkedBlockTileEntity)world.func_175625_s(pos);
        BlockState oldState = world.func_180495_p(pos);
        BlockState state = world.func_180495_p(pos);
        if (te.getColor() != color) {
            te.setColor(color);
        }
        if (InkBlockUtils.getInkBlock(inkType, state.func_177230_c()) != state.func_177230_c()) {
            state = InkBlockUtils.getInkState(inkType, state);
            world.func_180501_a(pos, state, 2);
            InkedBlockTileEntity newTe = (InkedBlockTileEntity)world.func_175625_s(pos);
            newTe.setSavedState(te.getSavedState());
            newTe.setColor(te.getColor());
            world.func_175690_a(pos, (TileEntity)newTe);
        } else {
            world.func_184138_a(pos, oldState, state, 2);
        }
        return te.getColor() != color || InkBlockUtils.getInkBlock(inkType, state.func_177230_c()) != state.func_177230_c();
    }
}

