/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.blocks.InkedBlock;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class InkedWoolBlock
extends Block
implements IColoredBlock {
    public InkedWoolBlock(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n).func_200943_b(0.8f).func_200947_a(SoundType.field_185854_g));
        SplatcraftBlocks.inkColoredBlocks.add(this);
        this.setRegistryName(name);
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ColorUtils.setInkColor(super.getPickBlock(state, target, world, pos, player), this.getColor((World)world, pos));
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77978_p() != null && world.func_175625_s(pos) instanceof InkColorTileEntity) {
            ColorUtils.setInkColor(world.func_175625_s(pos), ColorUtils.getInkColor(stack));
        }
        super.func_180633_a(world, pos, state, entity, stack);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return SplatcraftTileEntitites.colorTileEntity.func_200968_a();
    }

    @Override
    public boolean canClimb() {
        return false;
    }

    @Override
    public boolean canSwim() {
        return false;
    }

    @Override
    public boolean canDamage() {
        return false;
    }

    @Override
    public int getColor(World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
            return ((InkColorTileEntity)world.func_175625_s(pos)).getColor();
        }
        return -1;
    }

    @Override
    public boolean remoteColorChange(World world, BlockPos pos, int newColor) {
        BlockState state = world.func_180495_p(pos);
        if (world.func_175625_s(pos) instanceof InkColorTileEntity && ((InkColorTileEntity)world.func_175625_s(pos)).getColor() != newColor) {
            ((InkColorTileEntity)world.func_175625_s(pos)).setColor(newColor);
            world.func_184138_a(pos, state, state, 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean inkBlock(World world, BlockPos pos, int color, float damage, InkBlockUtils.InkType inkType) {
        if (InkedBlock.isTouchingLiquid((IBlockReader)world, pos)) {
            return false;
        }
        int woolColor = -1;
        if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
            woolColor = ((InkColorTileEntity)world.func_175625_s(pos)).getColor();
        }
        BlockState state = world.func_180495_p(pos);
        world.func_180501_a(pos, SplatcraftBlocks.inkedBlock.func_176223_P(), 3);
        world.func_175690_a(pos, SplatcraftBlocks.inkedBlock.createTileEntity(SplatcraftBlocks.inkedBlock.func_176223_P(), (IBlockReader)world));
        InkedBlockTileEntity inkte = (InkedBlockTileEntity)world.func_175625_s(pos);
        if (inkte == null) {
            return false;
        }
        inkte.setColor(color);
        inkte.setSavedState(state);
        inkte.setSavedColor(woolColor);
        return true;
    }

    @Override
    public boolean remoteInkClear(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean countsTowardsTurf(World world, BlockPos pos) {
        return false;
    }
}

