/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class InkwellBlock
extends Block
implements IColoredBlock,
IWaterLoggable {
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)InkwellBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{InkwellBlock.func_208617_a((double)1.0, (double)12.0, (double)1.0, (double)0.875, (double)13.0, (double)14.0), InkwellBlock.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)});
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final SoundType SOUND_TYPE = new SoundType(1.0f, 1.0f, SoundEvents.field_187835_fT, SoundEvents.field_187888_ft, SoundEvents.field_187567_bP, SoundEvents.field_187565_bO, SoundEvents.field_187876_fn);

    public InkwellBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151592_s).func_200943_b(0.35f).harvestTool(ToolType.PICKAXE).func_200947_a(SOUND_TYPE));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        SplatcraftBlocks.inkColoredBlocks.add(this);
    }

    @Nullable
    public float[] getBeaconColorMultiplier(BlockState state, IWorldReader world, BlockPos pos, BlockPos beaconPos) {
        return ColorUtils.hexToRGB(this.getColor((World)world, pos));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return ColorUtils.setInkColor(super.getPickBlock(state, target, world, pos, player), this.getColor((World)world, pos));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{WATERLOGGED});
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    public ItemStack func_185473_a(IBlockReader reader, BlockPos pos, BlockState state) {
        ItemStack stack = super.func_185473_a(reader, pos, state);
        if (reader.func_175625_s(pos) instanceof InkColorTileEntity) {
            ColorUtils.setInkColor(stack, ColorUtils.getInkColor(reader.func_175625_s(pos)));
        }
        return stack;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, ItemStack stack) {
        if (!world.field_72995_K && stack.func_77978_p() != null && world.func_175625_s(pos) instanceof InkColorTileEntity) {
            ColorUtils.setInkColor(world.func_175625_s(pos), ColorUtils.getInkColor(stack));
        }
        super.func_180633_a(world, pos, state, entity, stack);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return true;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return SplatcraftTileEntitites.inkwellTileEntity.func_200968_a();
    }

    @Override
    public boolean canClimb() {
        return false;
    }

    @Override
    public boolean canSwim() {
        return true;
    }

    @Override
    public boolean canDamage() {
        return false;
    }

    @Override
    public int getColor(World world, BlockPos pos) {
        if (world.func_175625_s(pos) instanceof InkColorTileEntity) {
            return ((InkColorTileEntity)world.func_175625_s(pos)).getColor();
        }
        return -1;
    }

    @Override
    public boolean remoteColorChange(World world, BlockPos pos, int newColor) {
        BlockState state = world.func_180495_p(pos);
        if (world.func_175625_s(pos) instanceof InkColorTileEntity && ((InkColorTileEntity)world.func_175625_s(pos)).getColor() != newColor) {
            ((InkColorTileEntity)world.func_175625_s(pos)).setColor(newColor);
            world.func_184138_a(pos, state, state, 2);
            return true;
        }
        return false;
    }

    @Override
    public boolean remoteInkClear(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean countsTowardsTurf(World world, BlockPos pos) {
        return false;
    }
}

