/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.blocks;

import com.cibernet.splatcraft.tileentities.container.WeaponWorkbenchContainer;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;

public class WeaponWorkbenchBlock
extends HorizontalBlock
implements IWaterLoggable {
    protected static final VoxelShape BOTTOM = VoxelShapes.func_197872_a((VoxelShape)WeaponWorkbenchBlock.func_208617_a((double)2.0, (double)0.0, (double)0.0, (double)5.0, (double)4.0, (double)16.0), (VoxelShape)WeaponWorkbenchBlock.func_208617_a((double)11.0, (double)0.0, (double)0.0, (double)14.0, (double)4.0, (double)16.0));
    protected static final VoxelShape BASE = WeaponWorkbenchBlock.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    protected static final VoxelShape DETAIL = VoxelShapes.func_197872_a((VoxelShape)WeaponWorkbenchBlock.func_208617_a((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)WeaponWorkbenchBlock.func_208617_a((double)5.0, (double)11.0, (double)0.0, (double)11.0, (double)12.0, (double)1.0));
    public static final VoxelShape[] SHAPES = WeaponWorkbenchBlock.createVoxelShapes(BOTTOM, BASE, DETAIL);
    public static final EnumProperty<Direction> FACING = field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final ITextComponent CONTAINER_NAME = new TranslationTextComponent("container.weapon_workbench");

    public WeaponWorkbenchBlock(String name) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_200943_b(2.0f).harvestTool(ToolType.PICKAXE).func_235861_h_());
        this.setRegistryName(name);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)Direction.NORTH)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        player.func_213829_a(this.func_220052_b(state, worldIn, pos));
        return ActionResultType.CONSUME;
    }

    public INamedContainerProvider func_220052_b(BlockState state, World worldIn, BlockPos pos) {
        return new SimpleNamedContainerProvider((id, inventory, player) -> new WeaponWorkbenchContainer(inventory, pos, id), CONTAINER_NAME);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        FluidState fluidstate = context.func_195991_k().func_204610_c(blockpos);
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[((Direction)state.func_177229_b(FACING)).ordinal() - 2];
    }

    protected static VoxelShape modifyShapeForDirection(Direction facing, VoxelShape shape) {
        AxisAlignedBB bb = shape.func_197752_a();
        switch (facing) {
            case EAST: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72334_f, bb.field_72338_b, bb.field_72340_a, 1.0 - bb.field_72339_c, bb.field_72337_e, bb.field_72336_d));
            }
            case SOUTH: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(1.0 - bb.field_72336_d, bb.field_72338_b, 1.0 - bb.field_72334_f, 1.0 - bb.field_72340_a, bb.field_72337_e, 1.0 - bb.field_72339_c));
            }
            case WEST: {
                return VoxelShapes.func_197881_a((AxisAlignedBB)new AxisAlignedBB(bb.field_72339_c, bb.field_72338_b, 1.0 - bb.field_72336_d, bb.field_72334_f, bb.field_72337_e, 1.0 - bb.field_72340_a));
            }
        }
        return shape;
    }

    public static VoxelShape[] createVoxelShapes(VoxelShape ... shapes) {
        VoxelShape[] result = new VoxelShape[4];
        for (int i = 0; i < 4; ++i) {
            result[i] = VoxelShapes.func_197880_a();
            for (int j = 0; j < shapes.length; ++j) {
                result[i] = VoxelShapes.func_197872_a((VoxelShape)result[i], (VoxelShape)WeaponWorkbenchBlock.modifyShapeForDirection(Direction.func_176731_b((int)i), shapes[j]));
            }
        }
        return result;
    }
}

