/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.capabilities.playerinfo;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.PlayerCharge;
import com.cibernet.splatcraft.util.PlayerCooldown;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.NonNullList;

public class PlayerInfo
implements IPlayerInfo {
    private int color;
    private boolean isSquid = false;
    private boolean initialized = false;
    private NonNullList<ItemStack> matchInventory = NonNullList.func_191196_a();
    private PlayerCooldown playerCooldown = null;
    private PlayerCharge playerCharge = null;

    public PlayerInfo(int defaultColor) {
        this.color = defaultColor;
    }

    public PlayerInfo() {
        this(ColorUtils.getRandomStarterColor());
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void setInitialized(boolean init) {
        this.initialized = init;
    }

    @Override
    public int getColor() {
        return this.color;
    }

    @Override
    public void setColor(int color) {
        this.color = color;
    }

    @Override
    public boolean isSquid() {
        return this.isSquid;
    }

    @Override
    public void setIsSquid(boolean isSquid) {
        this.isSquid = isSquid;
    }

    @Override
    public NonNullList<ItemStack> getMatchInventory() {
        return this.matchInventory;
    }

    @Override
    public void setMatchInventory(NonNullList<ItemStack> inventory) {
        this.matchInventory = inventory;
    }

    @Override
    public PlayerCooldown getPlayerCooldown() {
        return this.playerCooldown;
    }

    @Override
    public void setPlayerCooldown(PlayerCooldown cooldown) {
        this.playerCooldown = cooldown;
    }

    @Override
    public PlayerCharge getPlayerCharge() {
        return this.playerCharge;
    }

    @Override
    public void setPlayerCharge(PlayerCharge charge) {
        this.playerCharge = charge;
    }

    @Override
    public CompoundNBT writeNBT(CompoundNBT nbt) {
        nbt.func_74768_a("Color", this.getColor());
        nbt.func_74757_a("IsSquid", this.isSquid());
        nbt.func_74757_a("Initialized", this.initialized);
        if (!this.matchInventory.isEmpty()) {
            CompoundNBT invNBT = new CompoundNBT();
            ItemStackHelper.func_191282_a((CompoundNBT)invNBT, this.matchInventory);
            nbt.func_218657_a("MatchInventory", (INBT)invNBT);
        }
        if (this.playerCooldown != null) {
            CompoundNBT cooldownNBT = new CompoundNBT();
            this.playerCooldown.writeNBT(cooldownNBT);
            nbt.func_218657_a("PlayerCooldown", (INBT)cooldownNBT);
        }
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        this.setColor(nbt.func_74762_e("Color"));
        this.setIsSquid(nbt.func_74767_n("IsSquid"));
        this.setInitialized(nbt.func_74767_n("Initialized"));
        if (nbt.func_74764_b("MatchInventory")) {
            NonNullList nbtInv = NonNullList.func_191197_a((int)41, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt.func_74775_l("MatchInventory"), (NonNullList)nbtInv);
            this.setMatchInventory((NonNullList<ItemStack>)nbtInv);
        }
        if (nbt.func_74764_b("PlayerCooldown")) {
            this.setPlayerCooldown(PlayerCooldown.readNBT(nbt.func_74775_l("PlayerCooldown")));
        }
    }
}

