/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.capabilities.playerinfo;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoStorage;
import com.cibernet.splatcraft.entities.InkSquidEntity;
import com.cibernet.splatcraft.registries.SplatcraftInkColors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class PlayerInfoCapability
implements ICapabilitySerializable<CompoundNBT> {
    @CapabilityInject(value=IPlayerInfo.class)
    public static final Capability<IPlayerInfo> CAPABILITY = null;
    private LazyOptional<IPlayerInfo> instance = LazyOptional.of(() -> CAPABILITY.getDefaultInstance());
    private static final IPlayerInfo DEFAULT = new PlayerInfo(SplatcraftInkColors.undyed.getColor());

    public static void register() {
        CapabilityManager.INSTANCE.register(IPlayerInfo.class, (Capability.IStorage)new PlayerInfoStorage(), PlayerInfo::new);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return CAPABILITY.orEmpty(cap, this.instance);
    }

    public CompoundNBT serializeNBT() {
        return (CompoundNBT)CAPABILITY.getStorage().writeNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null);
    }

    public void deserializeNBT(CompoundNBT nbt) {
        CAPABILITY.getStorage().readNBT(CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("LazyOptional cannot be empty!")), null, (INBT)nbt);
    }

    public static IPlayerInfo get(LivingEntity entity) throws NullPointerException {
        return (IPlayerInfo)entity.getCapability(CAPABILITY).orElse(null);
    }

    public static boolean hasCapability(LivingEntity entity) {
        try {
            return PlayerInfoCapability.get(entity) != null;
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    public static boolean isSquid(LivingEntity entity) {
        if (entity instanceof InkSquidEntity) {
            return true;
        }
        try {
            return PlayerInfoCapability.get(entity).isSquid();
        }
        catch (NullPointerException e) {
            return false;
        }
    }
}

