/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.capabilities.saveinfo;

import com.cibernet.splatcraft.capabilities.saveinfo.ISaveInfo;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.CompoundNBT;

public class SaveInfo
implements ISaveInfo {
    private ArrayList<Integer> colorScores = new ArrayList();

    @Override
    public Collection<Integer> getInitializedColorScores() {
        return this.colorScores;
    }

    @Override
    public void addInitializedColorScores(Integer ... colors) {
        for (Integer color : colors) {
            if (this.colorScores.contains(color)) continue;
            this.colorScores.add(color);
        }
    }

    @Override
    public void removeColorScore(Integer color) {
        if (this.colorScores.contains(color)) {
            this.colorScores.remove(color);
        }
    }

    @Override
    public CompoundNBT writeNBT(CompoundNBT nbt) {
        int[] arr = new int[this.colorScores.size()];
        for (int i = 0; i < this.colorScores.size(); ++i) {
            arr[i] = this.colorScores.get(i);
        }
        nbt.func_74783_a("StoredCriteria", arr);
        return nbt;
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        this.colorScores = new ArrayList();
        ScoreboardHandler.clearColorCriteria();
        for (int i : nbt.func_74759_k("StoredCriteria")) {
            this.colorScores.add(i);
            ScoreboardHandler.createColorCriterion(i);
        }
    }
}

