/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.client.gui;

import com.cibernet.splatcraft.tileentities.InkVatTileEntity;
import com.cibernet.splatcraft.tileentities.container.InkVatContainer;
import com.cibernet.splatcraft.util.ColorUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class InkVatScreen
extends ContainerScreen<InkVatContainer> {
    private static final ResourceLocation TEXTURES = new ResourceLocation("splatcraft", "textures/gui/inkwell_crafting.png");
    private static final int colorSelectionX = 12;
    private static final int colorSelectionY = 16;
    private static final int scrollBarX = 15;
    private static final int scrollBarY = 55;
    private boolean scrolling = false;
    private boolean canScroll = false;
    private float maxScroll = 0.0f;
    private float scroll = 0.0f;

    public InkVatScreen(InkVatContainer screenContainer, PlayerInventory inv, ITextComponent titleIn) {
        super((Container)screenContainer, inv, titleIn);
        this.field_147000_g = 208;
        this.field_238744_r_ = 8;
        this.field_238745_s_ = this.field_147000_g - 98;
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_230459_a_(MatrixStack matrixStack, int mouseX, int mouseY) {
        List<Integer> colorSelection = ((InkVatContainer)this.field_147002_h).sortRecipeList();
        super.func_230459_a_(matrixStack, mouseX, mouseY);
        int sc = (int)Math.ceil(Math.max(0.0f, (float)(colorSelection.size() - 16) * this.scroll));
        sc += sc % 2;
        for (int i = sc; i < colorSelection.size() && i - sc < 16; ++i) {
            int x = 12 + (i - sc) / 2 * 19;
            int y = 16 + (i - sc) % 2 * 18;
            if (!this.func_195359_a(x, y, 18, 16, mouseX, mouseY)) continue;
            this.func_238652_a_(matrixStack, ColorUtils.getFormatedColorName(colorSelection.get(i), false), mouseX, mouseY);
        }
    }

    protected void func_230451_b_(MatrixStack matrixStack, int mouseX, int mouseY) {
        super.func_230451_b_(matrixStack, mouseX, mouseY);
        this.field_230712_o_.func_238421_b_(matrixStack, this.field_230704_d_.func_150261_e(), (float)(this.field_146999_f / 2 - this.field_230712_o_.func_78256_a(this.field_230704_d_.func_150261_e()) / 2), 4.0f, 0x404040);
        List<Integer> colors = ((InkVatContainer)this.field_147002_h).sortRecipeList();
        this.drawAvailableColors(matrixStack, colors, 12, 16);
        this.canScroll = colors.size() > 16;
        this.maxScroll = (float)Math.ceil((double)colors.size() / 2.0) - 8.0f;
        this.drawScrollBar(matrixStack, 15, 55, 132, mouseX, mouseY);
    }

    protected void drawAvailableColors(MatrixStack matrixStack, List<Integer> colorSelection, int x, int y) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES);
        int sc = (int)Math.ceil(Math.max(0.0f, (float)(colorSelection.size() - 16) * this.scroll));
        sc += sc % 2;
        for (int i = sc; i < colorSelection.size() && i - sc < 16; ++i) {
            int color = colorSelection.get(i);
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            int cx = x + (i - sc) / 2 * 19;
            int cy = y + (i - sc) % 2 * 18;
            RenderSystem.color4f((float)r, (float)g, (float)b, (float)1.0f);
            this.func_238474_b_(matrixStack, cx, cy, 34, 220, 19, 18);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (((InkVatContainer)this.field_147002_h).getSelectedRecipe() != i) continue;
            this.func_238474_b_(matrixStack, cx, cy, 34, 238, 19, 18);
        }
    }

    protected void drawScrollBar(MatrixStack matrixStack, int x, int y, int width, int mouseX, int mouseY) {
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES);
        if (this.canScroll) {
            this.func_238474_b_(matrixStack, (int)((float)x + (float)width * this.scroll), y, 241, this.func_195359_a(15, 55, 146, 10, mouseX, mouseY) || this.scrolling ? 20 : 0, 15, 10);
        } else {
            this.func_238474_b_(matrixStack, x, y, 241, 10, 15, 10);
        }
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURES);
        int x = (this.field_230708_k_ - this.field_146999_f) / 2;
        int y = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, x, y, 0, 0, this.field_146999_f, this.field_147000_g);
        InkVatTileEntity te = ((InkVatContainer)this.field_147002_h).te;
        if (te.func_70301_a(0).func_190926_b()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 26, this.field_147009_r + 70, 176, 0, 16, 16);
        }
        if (te.func_70301_a(1).func_190926_b()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 46, this.field_147009_r + 70, 192, 0, 16, 16);
        }
        if (te.func_70301_a(2).func_190926_b()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 92, this.field_147009_r + 82, 208, 0, 16, 16);
        }
        if (te.func_70301_a(3).func_190926_b()) {
            this.func_238474_b_(matrixStack, this.field_147003_i + 36, this.field_147009_r + 89, 224, 0, 16, 16);
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        List<Integer> colorSelection = ((InkVatContainer)this.field_147002_h).sortRecipeList();
        this.scrolling = false;
        int sc = (int)Math.ceil(Math.max(0.0f, (float)(colorSelection.size() - 16) * this.scroll));
        sc += sc % 2;
        for (int i = sc; i < colorSelection.size() && i - sc < 16; ++i) {
            int x = 12 + (i - sc) / 2 * 19;
            int y = 16 + (i - sc) % 2 * 18;
            if (!this.func_195359_a(x, y, 19, 18, mouseX, mouseY) || mouseButton != 0 || !((InkVatContainer)this.field_147002_h).func_75140_a((PlayerEntity)this.field_230706_i_.field_71439_g, i)) continue;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_219720_mm, (float)1.0f));
            this.field_230706_i_.field_71442_b.func_78756_a(((InkVatContainer)this.field_147002_h).field_75152_c, i);
            ((InkVatContainer)this.field_147002_h).updateInkVatColor(i, colorSelection.get(i));
        }
        if (this.func_195359_a(15, 55, 146, 10, mouseX, mouseY) && this.canScroll) {
            this.scrolling = true;
            this.scroll = MathHelper.func_76131_a((float)((float)(mouseX - (double)this.field_147003_i - 15.0) / 132.0f), (float)0.0f, (float)1.0f);
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.scrolling = false;
        }
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public boolean func_231045_a_(double x, double y, int mouseButton, double p_231045_6_, double p_231045_8_) {
        if (this.scrolling && this.canScroll) {
            int i = this.field_147009_r + 15;
            int j = i + 132;
            this.scroll = MathHelper.func_76131_a((float)((float)(x - (double)this.field_147003_i - 15.0) / 132.0f), (float)0.0f, (float)1.0f);
        }
        return super.func_231045_a_(x, y, mouseButton, p_231045_6_, p_231045_8_);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double amount) {
        if (this.canScroll) {
            this.scroll = MathHelper.func_76131_a((float)(this.scroll + 1.0f / this.maxScroll * -Math.signum((float)amount)), (float)0.0f, (float)1.0f);
        }
        return true;
    }
}

