/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.client.layer;

import com.cibernet.splatcraft.client.model.SquidBumperModel;
import com.cibernet.splatcraft.entities.SquidBumperEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;

public class SquidBumperColorLayer
extends LayerRenderer<SquidBumperEntity, SquidBumperModel> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("splatcraft", "textures/mobs/squid_bumper.png");
    private final SquidBumperModel MODEL = new SquidBumperModel();

    public SquidBumperColorLayer(IEntityRenderer<SquidBumperEntity, SquidBumperModel> renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int packedLightIn, SquidBumperEntity entity, float v, float v1, float v2, float v3, float v4, float v5) {
        int color = ColorUtils.getEntityColor(entity);
        float r = (float)((color & 0xFF0000) >> 16) / 255.0f;
        float g = (float)((color & 0xFF00) >> 8) / 255.0f;
        float b = (float)((color & 0xFF) >> 0) / 255.0f;
        SquidBumperColorLayer.renderCopyCutoutModel((SquidBumperModel)this.func_215332_c(), this.MODEL, TEXTURE, matrixStack, bufferIn, packedLightIn, entity, v, v1, v2, v3, v4, v5, r, g, b);
    }

    protected static <T extends SquidBumperEntity> void renderCopyCutoutModel(SquidBumperModel modelParentIn, SquidBumperModel modelIn, ResourceLocation textureLocationIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTicks, float red, float green, float blue) {
        if (!entityIn.func_82150_aj()) {
            modelParentIn.func_217111_a(modelIn);
            modelIn.setLivingAnimations(entityIn, limbSwing, limbSwingAmount, partialTicks);
            modelIn.setRotationAngles(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            SquidBumperColorLayer.renderCutoutModel(modelIn, textureLocationIn, matrixStackIn, bufferIn, packedLightIn, entityIn, red, green, blue);
        }
    }

    protected static <T extends LivingEntity> void renderCutoutModel(SquidBumperModel modelIn, ResourceLocation textureLocationIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, SquidBumperEntity entityIn, float red, float green, float blue) {
        IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228640_c_((ResourceLocation)textureLocationIn));
        modelIn.renderBase(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entityIn, (float)0.0f), red, green, blue, 1.0f);
        float scale = entityIn.getInkHealth() <= 0.0f ? (float)(10 - Math.min(entityIn.getRespawnTime(), 10)) / 10.0f : 1.0f;
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227862_a_(scale, scale, scale);
        modelIn.renderBumper(matrixStackIn, ivertexbuilder, packedLightIn, LivingRenderer.func_229117_c_((LivingEntity)entityIn, (float)0.0f), red, green, blue, 1.0f);
        matrixStackIn.func_227865_b_();
    }
}

