/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.client.model;

import com.cibernet.splatcraft.entities.SquidBumperEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;

public class SquidBumperModel
extends EntityModel<SquidBumperEntity> {
    private final ModelRenderer Base;
    private final ModelRenderer Bumper;
    private final ModelRenderer Left_Side;
    private final ModelRenderer Right_Side;

    public SquidBumperModel() {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
        this.Base = new ModelRenderer((Model)this);
        this.Base.func_78793_a(0.0f, 24.0f, 0.0f);
        this.Base.func_78784_a(0, 46).func_228303_a_(-5.0f, -2.0f, -5.0f, 10.0f, 2.0f, 10.0f, 0.0f, false);
        this.Bumper = new ModelRenderer((Model)this);
        this.Bumper.func_78793_a(0.0f, 24.0f, 0.0f);
        this.Bumper.func_78784_a(0, 0).func_228303_a_(-7.0f, -16.0f, -7.0f, 14.0f, 14.0f, 14.0f, 0.0f, false);
        this.Bumper.func_78784_a(0, 28).func_228303_a_(-6.0f, -22.0f, -6.0f, 12.0f, 6.0f, 12.0f, 0.0f, false);
        this.Bumper.func_78784_a(56, 1).func_228303_a_(-5.0f, -27.0f, -5.0f, 10.0f, 5.0f, 10.0f, 0.0f, false);
        this.Bumper.func_78784_a(56, 17).func_228303_a_(-4.0f, -30.0f, -4.0f, 8.0f, 3.0f, 8.0f, 0.0f, false);
        this.Left_Side = new ModelRenderer((Model)this);
        this.Left_Side.func_78793_a(3.3308f, -12.7034f, 0.5f);
        this.Bumper.func_78792_a(this.Left_Side);
        this.setRotationAngle(this.Left_Side, 0.0f, 0.0f, 0.7854f);
        this.Left_Side.func_78784_a(72, 28).func_228303_a_(-11.3308f, -12.0465f, -1.5f, 10.0f, 10.0f, 2.0f, 0.0f, false);
        this.Right_Side = new ModelRenderer((Model)this);
        this.Right_Side.func_78793_a(-3.3308f, -12.7034f, 0.5f);
        this.Bumper.func_78792_a(this.Right_Side);
        this.setRotationAngle(this.Right_Side, 0.0f, 0.0f, -0.7854f);
        this.Right_Side.func_78784_a(48, 28).func_228303_a_(1.3261f, -12.0465f, -1.5f, 10.0f, 10.0f, 2.0f, 0.0f, true);
    }

    public void setRotationAngles(SquidBumperEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void setLivingAnimations(SquidBumperEntity entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_((Entity)entityIn, limbSwing, limbSwingAmount, partialTick);
        this.Bumper.field_78796_g = (float)Math.PI / 180 * MathHelper.func_219805_h((float)partialTick, (float)entityIn.field_70758_at, (float)entityIn.field_70758_at) + (float)Math.PI;
        this.Base.field_78795_f = 0.0f;
        this.Base.field_78796_g = 0.0f;
        this.Base.field_78808_h = 0.0f;
        float scale = (float)(10 - Math.min(entityIn.getRespawnTime(), 10)) / 10.0f;
        this.Bumper.field_78797_d = 24.0f;
        if (entityIn.getInkHealth() <= 0.0f) {
            this.Bumper.field_78797_d *= 1.0f / scale;
        }
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.renderBase(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
        this.renderBumper(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void render(SquidBumperEntity entityIn, MatrixStack matrixStackIn, IVertexBuilder builderIn, int packedLightIn) {
        float scale = (float)(10 - Math.min(entityIn.getRespawnTime(), 10)) / 10.0f;
        int color = entityIn.getColor();
        float r = (float)(Math.floor(color / 65536) / 255.0);
        float g = (float)(Math.floor(color / 256) % 256.0 / 255.0);
        float b = (float)(color % 256) / 255.0f;
        this.renderBase(matrixStackIn, builderIn, packedLightIn, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.0, (double)(24.0f * (scale > 0.0f ? 1.0f / scale : 0.0f)), 0.0);
        matrixStackIn.func_227862_a_(scale, scale, scale);
        this.renderBumper(matrixStackIn, builderIn, packedLightIn, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
        matrixStackIn.func_227865_b_();
    }

    public void renderBase(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Base.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void renderBumper(MatrixStack matrixStack, IVertexBuilder buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Bumper.func_228309_a_(matrixStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void setRotationAngle(ModelRenderer modelRenderer, float x, float y, float z) {
        modelRenderer.field_78795_f = x;
        modelRenderer.field_78796_g = y;
        modelRenderer.field_78808_h = z;
    }
}

