/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.client.renderer;

import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.tileentities.InkedBlockTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class InkedBlockTileEntityRenderer
extends TileEntityRenderer<InkedBlockTileEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("splatcraft", "blocks/power_egg_block");

    public InkedBlockTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(InkedBlockTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
        blockRenderer.renderBlock(SplatcraftBlocks.sardiniumBlock.func_176223_P(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    private static void renderBlock(InkedBlockTileEntity te, BlockRendererDispatcher blockRendererDispatcher, MatrixStack matrixStackIn, IRenderTypeBuffer bufferTypeIn, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockStateIn = te.func_195044_w();
        BlockRenderType blockrendertype = te.getSavedState().func_185901_i();
        if (blockrendertype.equals((Object)BlockRenderType.MODEL)) {
            blockStateIn = te.getSavedState();
        }
        IBakedModel ibakedmodel = blockRendererDispatcher.func_184389_a(blockStateIn);
        int i = ColorUtils.getInkColor(te);
        float f = (float)(i >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(i & 0xFF) / 255.0f;
        InkedBlockTileEntityRenderer.renderModel(matrixStackIn.func_227866_c_(), bufferTypeIn.getBuffer(RenderTypeLookup.func_239220_a_((BlockState)blockStateIn, (boolean)false)), blockStateIn, ibakedmodel, f, f1, f2, combinedLightIn, combinedOverlayIn, (IModelData)EmptyModelData.INSTANCE);
    }

    private static void renderModel(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, @Nullable BlockState state, IBakedModel modelIn, float red, float green, float blue, int combinedLightIn, int combinedOverlayIn, IModelData modelData) {
        Random random = new Random();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            InkedBlockTileEntityRenderer.renderModelBrightnessColorQuads(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, direction, random, modelData), combinedLightIn, combinedOverlayIn);
        }
        random.setSeed(42L);
        InkedBlockTileEntityRenderer.renderModelBrightnessColorQuads(matrixEntry, buffer, red, green, blue, modelIn.getQuads(state, (Direction)null, random, modelData), combinedLightIn, combinedOverlayIn);
    }

    private static void renderModelBrightnessColorQuads(MatrixStack.Entry matrixEntry, IVertexBuilder buffer, float red, float green, float blue, List<BakedQuad> quads, int combinedLightIn, int combinedOverlayIn) {
        for (BakedQuad bakedquad : quads) {
            float f = MathHelper.func_76131_a((float)red, (float)0.0f, (float)1.0f);
            float f1 = MathHelper.func_76131_a((float)green, (float)0.0f, (float)1.0f);
            float f2 = MathHelper.func_76131_a((float)blue, (float)0.0f, (float)1.0f);
            TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(TEXTURE);
            BakedQuad renderedQuad = new BakedQuad(bakedquad.func_178209_a(), bakedquad.func_178211_c(), bakedquad.func_178210_d(), sprite, bakedquad.func_239287_f_());
            renderedQuad = bakedquad;
            buffer.func_227889_a_(matrixEntry, renderedQuad, f, f1, f2, combinedLightIn, combinedOverlayIn);
        }
    }
}

