/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.client.renderer;

import com.cibernet.splatcraft.blocks.StageBarrierBlock;
import com.cibernet.splatcraft.handlers.client.RendererHandler;
import com.cibernet.splatcraft.tileentities.StageBarrierTileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class StageBarrierTileEntityRenderer
extends TileEntityRenderer<StageBarrierTileEntity> {
    private static final RenderType BARRIER_RENDER = RenderType.func_228633_a_((String)"splatcraft:stage_barriers", (VertexFormat)DefaultVertexFormats.field_176600_a, (int)7, (int)131072, (boolean)true, (boolean)false, (RenderType.State)RenderType.State.func_228694_a_().func_228723_a_(new RenderState.ShadeModelState(true)).func_228719_a_(new RenderState.LightmapState(true)).func_228724_a_(new RenderState.TextureState(AtlasTexture.field_110575_b, false, true)).func_228713_a_(new RenderState.AlphaState(0.003921569f)).func_228726_a_(RendererHandler.TRANSLUCENT_TRANSPARENCY).func_228728_a_(true));

    public StageBarrierTileEntityRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    private void addVertex(IVertexBuilder builder, MatrixStack matrixStack, float x, float y, float z, float textureX, float textureY, float r, float g, float b, float a) {
        builder.func_227888_a_(matrixStack.func_227866_c_().func_227870_a_(), x, y, z).func_227885_a_(r, g, b, a).func_225583_a_(textureX, textureY).func_225587_b_(0, 240).func_225584_a_(1.0f, 0.0f, 0.0f).func_181675_d();
    }

    public void render(StageBarrierTileEntity tileEntity, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int combinedLight, int combinedOverlay) {
        float activeTime = tileEntity.getActiveTime();
        Block block = tileEntity.func_195044_w().func_177230_c();
        if (activeTime <= 0.0f || !(block instanceof StageBarrierBlock)) {
            return;
        }
        ResourceLocation textureLoc = new ResourceLocation("splatcraft", "blocks/" + block.getRegistryName().func_110623_a() + (Minecraft.func_71410_x().field_71474_y.field_238330_f_.func_238162_a_() > 0 ? "_fancy" : ""));
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.func_71410_x().func_228015_a_(AtlasTexture.field_110575_b).apply(textureLoc);
        IVertexBuilder builder = buffer.getBuffer(BARRIER_RENDER);
        float alpha = activeTime / tileEntity.getMaxActiveTime();
        matrixStack.func_227860_a_();
        if (StageBarrierTileEntityRenderer.canRenderSide(tileEntity, Direction.NORTH)) {
            this.addVertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
        }
        if (StageBarrierTileEntityRenderer.canRenderSide(tileEntity, Direction.SOUTH)) {
            this.addVertex(builder, matrixStack, 0.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 0.0f, 1.0f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 1.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
        }
        if (StageBarrierTileEntityRenderer.canRenderSide(tileEntity, Direction.WEST)) {
            this.addVertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
        }
        if (StageBarrierTileEntityRenderer.canRenderSide(tileEntity, Direction.EAST)) {
            this.addVertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
        }
        if (StageBarrierTileEntityRenderer.canRenderSide(tileEntity, Direction.DOWN)) {
            this.addVertex(builder, matrixStack, 0.0f, 0.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 0.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 0.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 0.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
        }
        if (StageBarrierTileEntityRenderer.canRenderSide(tileEntity, Direction.UP)) {
            this.addVertex(builder, matrixStack, 0.0f, 1.0f, 1.0f, sprite.func_94209_e(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 1.0f, 1.0f, sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 1.0f, 1.0f, 0.0f, sprite.func_94212_f(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
            this.addVertex(builder, matrixStack, 0.0f, 1.0f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), 1.0f, 1.0f, 1.0f, alpha);
        }
        matrixStack.func_227865_b_();
    }

    private static boolean canRenderSide(TileEntity te, Direction side) {
        BlockPos pos = te.func_174877_v().func_177972_a(side);
        BlockState state = te.func_145831_w().func_180495_p(pos);
        return !(state.func_177230_c() instanceof StageBarrierBlock);
    }
}

