/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.commands;

import com.cibernet.splatcraft.capabilities.saveinfo.SaveInfoCapability;
import com.cibernet.splatcraft.commands.arguments.ColorCriterionArgument;
import com.cibernet.splatcraft.commands.arguments.InkColorArgument;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import com.cibernet.splatcraft.util.ColorUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Set;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ColorScoresCommand {
    private static final SimpleCommandExceptionType CRITERION_ALREADY_EXISTS_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.colorscores.add.duplicate"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"colorscores").then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"color", (ArgumentType)InkColorArgument.inkColor()).executes(context -> ColorScoresCommand.add((CommandContext<CommandSource>)context))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"color", (ArgumentType)ColorCriterionArgument.colorCriterion()).executes(context -> ColorScoresCommand.remove((CommandContext<CommandSource>)context))))).then(Commands.func_197057_a((String)"list").executes(context -> ColorScoresCommand.list((CommandContext<CommandSource>)context))));
    }

    protected static int add(CommandContext<CommandSource> context) throws CommandSyntaxException {
        int color = InkColorArgument.getInkColor(context, "color");
        CommandSource source = (CommandSource)context.getSource();
        if (ScoreboardHandler.hasColorCriterion(color)) {
            throw CRITERION_ALREADY_EXISTS_EXCEPTION.create();
        }
        ScoreboardHandler.createColorCriterion(color);
        SaveInfoCapability.get(((CommandSource)context.getSource()).func_197028_i()).addInitializedColorScores(color);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.colorscores.add.success", new Object[]{ColorUtils.getFormatedColorName(color, false)}), true);
        return color;
    }

    protected static int remove(CommandContext<CommandSource> context) {
        int color = ColorCriterionArgument.getInkColor(context, "color");
        ScoreboardHandler.removeColorCriterion(color);
        SaveInfoCapability.get(((CommandSource)context.getSource()).func_197028_i()).removeColorScore(color);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.colorscores.remove.success", new Object[]{ColorUtils.getFormatedColorName(color, false)}), true);
        return color;
    }

    protected static int list(CommandContext<CommandSource> context) {
        Set<Integer> collection = ScoreboardHandler.getCriteriaKeySet();
        if (collection.isEmpty()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.colorscores.list.empty"), false);
        } else {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.colorscores.list.count", new Object[]{collection.size()}), false);
            collection.forEach(color -> ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.colorscores.list.entry", new Object[]{ScoreboardHandler.getColorIdentifier(color), ColorUtils.getFormatedColorName(color, false)}), false));
        }
        return collection.size();
    }
}

