/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.commands;

import com.cibernet.splatcraft.commands.arguments.InkColorArgument;
import com.cibernet.splatcraft.util.ColorUtils;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class InkColorCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"inkcolor").requires(commandSource -> commandSource.func_197034_c(2))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"color", (ArgumentType)InkColorArgument.inkColor()).executes(context -> InkColorCommand.setColor((CommandSource)context.getSource(), InkColorArgument.getInkColor((CommandContext<CommandSource>)context, "color")))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> InkColorCommand.setColor((CommandSource)context.getSource(), InkColorArgument.getInkColor((CommandContext<CommandSource>)context, "color"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))));
    }

    private static int setColor(CommandSource source, int color) throws CommandSyntaxException {
        ColorUtils.setPlayerColor((PlayerEntity)source.func_197035_h(), color);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.inkcolor.success.single", new Object[]{source.func_197035_h().func_145748_c_(), ColorUtils.getFormatedColorName(color, false)}), true);
        return 1;
    }

    private static int setColor(CommandSource source, int color, Collection<ServerPlayerEntity> targets) {
        targets.forEach(player -> ColorUtils.setPlayerColor((PlayerEntity)player, color));
        if (targets.size() == 1) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.inkcolor.success.single", new Object[]{ColorUtils.getFormatedColorName(color, false), targets.iterator().next().func_145748_c_()}), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.inkcolor.success.multiple", new Object[]{ColorUtils.getFormatedColorName(color, false), targets.size()}), true);
        }
        return targets.size();
    }
}

