/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.crafting;

import com.cibernet.splatcraft.crafting.SplatcraftRecipeTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.registries.ForgeRegistryEntry;

public abstract class AbstractWeaponWorkbenchRecipe
implements IRecipe<IInventory> {
    protected final ResourceLocation id;
    protected final ItemStack recipeOutput;
    protected final NonNullList<Ingredient> recipeItems;
    protected final String name;

    public AbstractWeaponWorkbenchRecipe(ResourceLocation id, String name, ItemStack recipeOutput, NonNullList<Ingredient> recipeItems) {
        this.id = id;
        this.recipeOutput = recipeOutput;
        this.recipeItems = recipeItems;
        this.name = name;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int i = 0;
        for (int j = 0; j < inv.func_70302_i_(); ++j) {
            ItemStack itemstack = inv.func_70301_a(j);
            if (itemstack.func_190926_b()) continue;
            ++i;
            inputs.add(itemstack);
        }
        return i == this.recipeItems.size() && RecipeMatcher.findMatches(inputs, this.recipeItems) != null;
    }

    public TextComponent getName() {
        return new TranslationTextComponent(this.name);
    }

    public ItemStack func_77572_b(IInventory inv) {
        return this.recipeOutput;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return this.recipeOutput;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SplatcraftRecipeTypes.WEAPON_STATION;
    }

    public IRecipeType<?> func_222127_g() {
        return SplatcraftRecipeTypes.WEAPON_STATION_TYPE;
    }

    public ItemStack getOutput() {
        return this.recipeOutput;
    }

    public NonNullList<Ingredient> getInput() {
        return this.recipeItems;
    }

    public static class Serializer<T extends AbstractWeaponWorkbenchRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        public Serializer(String name) {
            this.setRegistryName(name);
        }

        protected static NonNullList<Ingredient> readIngredients(JsonArray p_199568_0_) {
            NonNullList nonnulllist = NonNullList.func_191196_a();
            for (int i = 0; i < p_199568_0_.size(); ++i) {
                Ingredient ingredient = Ingredient.func_199802_a((JsonElement)p_199568_0_.get(i));
                if (ingredient.func_203189_d()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            return null;
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            return null;
        }

        public void write(PacketBuffer buffer, T recipe) {
        }
    }
}

