/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.crafting;

import com.cibernet.splatcraft.crafting.SplatcraftRecipeTypes;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.util.ColorUtils;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class InkVatColorRecipe
implements IRecipe<IInventory> {
    protected final Ingredient ingredient;
    protected final int color;
    protected final boolean disableOmni;
    protected final ResourceLocation id;
    protected static final ArrayList<Integer> omniColors = Lists.newArrayList();

    public InkVatColorRecipe(ResourceLocation id, Ingredient input, int outputColor, boolean disableOmni) {
        this.id = id;
        this.disableOmni = disableOmni;
        this.ingredient = input;
        this.color = outputColor;
        if (!disableOmni && !omniColors.contains(this.color)) {
            omniColors.add(this.color);
        }
    }

    public static Collection<Integer> getOmniList() {
        return omniColors;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return this.ingredient.test(inv.func_70301_a(3));
    }

    public ItemStack func_77572_b(IInventory inv) {
        return inv.func_70301_a(0);
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public ItemStack func_77571_b() {
        return ColorUtils.setInkColor(new ItemStack((IItemProvider)SplatcraftBlocks.inkwell), this.color);
    }

    public int getOutputColor() {
        return this.color;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SplatcraftRecipeTypes.INK_VAT_COLOR_CRAFTING;
    }

    public IRecipeType<?> func_222127_g() {
        return SplatcraftRecipeTypes.INK_VAT_COLOR_CRAFTING_TYPE;
    }

    public ItemStack func_222128_h() {
        return new ItemStack((IItemProvider)SplatcraftItems.inkVat);
    }

    public static class InkVatColorSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<InkVatColorRecipe> {
        public InkVatColorSerializer(String name) {
            this.setRegistryName(name);
        }

        public InkVatColorRecipe read(ResourceLocation recipeId, JsonObject json) {
            Integer color;
            Ingredient ingredient = json.has("filter") ? Ingredient.func_199802_a((JsonElement)json.get("filter")) : Ingredient.field_193370_a;
            boolean disableOmni = json.has("not_on_omni_filter") ? JSONUtils.func_151212_i((JsonObject)json, (String)"not_on_omni_filter") : false;
            try {
                color = JSONUtils.func_151203_m((JsonObject)json, (String)"color");
            }
            catch (JsonSyntaxException e) {
                color = Integer.parseInt(JSONUtils.func_151200_h((JsonObject)json, (String)"color"), 16);
            }
            return new InkVatColorRecipe(recipeId, ingredient, color, disableOmni);
        }

        @Nullable
        public InkVatColorRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new InkVatColorRecipe(recipeId, Ingredient.func_199566_b((PacketBuffer)buffer), buffer.readInt(), buffer.readBoolean());
        }

        public void write(PacketBuffer buffer, InkVatColorRecipe recipe) {
            recipe.ingredient.func_199564_a(buffer);
            buffer.writeInt(recipe.color);
            buffer.writeBoolean(recipe.disableOmni);
        }
    }
}

