/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.crafting;

import com.cibernet.splatcraft.crafting.AbstractWeaponWorkbenchRecipe;
import com.cibernet.splatcraft.crafting.WeaponWorkbenchSubtypeRecipe;
import com.cibernet.splatcraft.crafting.WeaponWorkbenchTab;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class WeaponWorkbenchRecipe
extends AbstractWeaponWorkbenchRecipe {
    private final ResourceLocation tab;
    private final NonNullList<WeaponWorkbenchSubtypeRecipe> subtypes = NonNullList.func_191196_a();

    public WeaponWorkbenchRecipe(ResourceLocation id, String name, ResourceLocation tab, ItemStack recipeOutput, NonNullList<Ingredient> recipeItems) {
        super(id, name, recipeOutput, recipeItems);
        this.tab = tab;
    }

    public WeaponWorkbenchTab getTab(World world) {
        IRecipe tab = (IRecipe)world.func_199532_z().func_215367_a(this.tab).get();
        return tab instanceof WeaponWorkbenchTab ? (WeaponWorkbenchTab)tab : null;
    }

    public void updateSubtypes(World world) {
        this.subtypes.clear();
        List<IRecipe> stream = world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe instanceof WeaponWorkbenchSubtypeRecipe && ((WeaponWorkbenchSubtypeRecipe)recipe).getParentRecipe(world).equals(this)).collect(Collectors.toList());
        stream.forEach(recipe -> this.subtypes.add((Object)((WeaponWorkbenchSubtypeRecipe)recipe)));
    }

    public AbstractWeaponWorkbenchRecipe getRecipeFromIndex(int index) {
        if (index == 0) {
            return this;
        }
        return (AbstractWeaponWorkbenchRecipe)this.subtypes.get(index + 1);
    }

    public static class Serializer
    extends AbstractWeaponWorkbenchRecipe.Serializer<WeaponWorkbenchRecipe> {
        public Serializer(String name) {
            super(name);
        }

        @Override
        public WeaponWorkbenchRecipe read(ResourceLocation recipeId, JsonObject json) {
            ResourceLocation tab = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"tab"));
            ItemStack output = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            NonNullList<Ingredient> input = Serializer.readIngredients(json.getAsJsonArray("ingredients"));
            String name = JSONUtils.func_151200_h((JsonObject)json, (String)"name");
            return new WeaponWorkbenchRecipe(recipeId, name, tab, output, input);
        }

        @Override
        @Nullable
        public WeaponWorkbenchRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            int i = buffer.func_150792_a();
            NonNullList input = NonNullList.func_191197_a((int)i, (Object)Ingredient.field_193370_a);
            for (int j = 0; j < input.size(); ++j) {
                input.set(j, (Object)Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            return new WeaponWorkbenchRecipe(recipeId, buffer.func_218666_n(), buffer.func_192575_l(), buffer.func_150791_c(), (NonNullList<Ingredient>)input);
        }

        @Override
        public void write(PacketBuffer buffer, WeaponWorkbenchRecipe recipe) {
            buffer.func_150787_b(recipe.recipeItems.size());
            for (Ingredient ingredient : recipe.recipeItems) {
                ingredient.func_199564_a(buffer);
            }
            buffer.func_180714_a(recipe.name);
            buffer.func_192572_a(recipe.tab);
            buffer.func_150788_a(recipe.recipeOutput);
        }
    }
}

