/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.crafting;

import com.cibernet.splatcraft.crafting.SplatcraftRecipeTypes;
import com.cibernet.splatcraft.crafting.WeaponWorkbenchRecipe;
import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class WeaponWorkbenchTab
implements IRecipe<IInventory>,
Comparable<WeaponWorkbenchTab> {
    protected final ResourceLocation id;
    protected final ResourceLocation iconLoc;
    protected final int pos;

    public WeaponWorkbenchTab(ResourceLocation id, ResourceLocation iconLoc, int pos) {
        this.id = id;
        this.iconLoc = iconLoc;
        this.pos = pos;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        return true;
    }

    public ItemStack func_77572_b(IInventory inv) {
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SplatcraftRecipeTypes.WEAPON_STATION_TAB;
    }

    public IRecipeType<?> func_222127_g() {
        return SplatcraftRecipeTypes.WEAPON_STATION_TAB_TYPE;
    }

    public List<WeaponWorkbenchRecipe> getTabRecipes(World world) {
        List<IRecipe> stream = world.func_199532_z().func_199510_b().stream().filter(recipe -> recipe instanceof WeaponWorkbenchRecipe && ((WeaponWorkbenchRecipe)recipe).getTab(world).equals(this)).collect(Collectors.toList());
        ArrayList recipes = Lists.newArrayList();
        stream.forEach(recipe -> recipes.add((WeaponWorkbenchRecipe)recipe));
        return recipes;
    }

    @Override
    public int compareTo(WeaponWorkbenchTab o) {
        return this.pos - o.pos;
    }

    public ResourceLocation getTabIcon() {
        return this.iconLoc;
    }

    public static class WeaponWorkbenchTabSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<WeaponWorkbenchTab> {
        public WeaponWorkbenchTabSerializer(String name) {
            this.setRegistryName(name);
        }

        public WeaponWorkbenchTab read(ResourceLocation recipeId, JsonObject json) {
            return new WeaponWorkbenchTab(recipeId, new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"icon")), json.has("pos") ? JSONUtils.func_151203_m((JsonObject)json, (String)"pos") : Integer.MAX_VALUE);
        }

        @Nullable
        public WeaponWorkbenchTab read(ResourceLocation recipeId, PacketBuffer buffer) {
            return new WeaponWorkbenchTab(recipeId, buffer.func_192575_l(), buffer.readInt());
        }

        public void write(PacketBuffer buffer, WeaponWorkbenchTab recipe) {
            buffer.func_192572_a(recipe.iconLoc);
            buffer.writeInt(recipe.pos);
        }
    }
}

