/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities;

import com.cibernet.splatcraft.entities.IColoredEntity;
import com.cibernet.splatcraft.handlers.WeaponHandler;
import com.cibernet.splatcraft.registries.SplatcraftEntities;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.InkDamageUtils;
import com.cibernet.splatcraft.util.InkExplosion;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileItemEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class InkProjectileEntity
extends ProjectileItemEntity
implements IColoredEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(SlimeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> PROJ_SIZE = EntityDataManager.func_187226_a(SlimeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DamageSource DAMAGE_SOURCE = new DamageSource("ink");
    public float gravityVelocity = 0.075f;
    public int lifespan = 600;
    public boolean explodes = false;
    public float damage = 0.0f;
    public float splashDamage = 0.0f;
    public boolean damageMobs = false;
    public boolean canPierce = false;
    public ItemStack sourceWeapon = ItemStack.field_190927_a;
    public float trailSize;
    public float trailCooldown = 0.0f;
    public InkBlockUtils.InkType inkType;

    public InkProjectileEntity(EntityType<? extends ProjectileItemEntity> type, World world) {
        super(type, world);
    }

    public InkProjectileEntity(World world, LivingEntity thrower, int color, InkBlockUtils.InkType inkType, float size, float damage, ItemStack sourceWeapon) {
        super(SplatcraftEntities.INK_PROJECTILE, thrower, world);
        this.setColor(color);
        this.setProjectileSize(size);
        this.damage = damage;
        this.inkType = inkType;
        this.sourceWeapon = sourceWeapon;
    }

    public InkProjectileEntity(World world, LivingEntity thrower, int color, InkBlockUtils.InkType inkType, float size, float damage) {
        this(world, thrower, color, inkType, size, damage, ItemStack.field_190927_a);
    }

    public InkProjectileEntity(World world, LivingEntity thrower, ItemStack sourceWeapon, InkBlockUtils.InkType inkType, float size, float damage) {
        this(world, thrower, ColorUtils.getInkColor(sourceWeapon), inkType, size, damage, sourceWeapon);
    }

    public InkProjectileEntity setShooterTrail() {
        this.trailCooldown = 4.0f;
        this.trailSize = this.getProjectileSize() * 0.7f;
        return this;
    }

    public InkProjectileEntity setChargerStats(int lifespan) {
        this.trailSize = this.getProjectileSize() * 0.85f;
        this.lifespan = lifespan;
        this.gravityVelocity = 0.0f;
        this.canPierce = true;
        return this;
    }

    public InkProjectileEntity setBlasterStats(int lifespan, float splashDamage) {
        this.lifespan = lifespan;
        this.splashDamage = splashDamage;
        this.gravityVelocity = 0.0f;
        this.trailSize = this.getProjectileSize() * 0.45f;
        this.explodes = true;
        return this;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(COLOR, (Object)2039597);
        this.field_70180_af.func_187214_a(PROJ_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void func_184206_a(DataParameter<?> dataParameter) {
        if (dataParameter.equals(PROJ_SIZE)) {
            this.func_213323_x_();
        }
        super.func_184206_a(dataParameter);
    }

    protected Item func_213885_i() {
        return SplatcraftItems.splattershot;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.lifespan-- <= 0) {
            InkExplosion.createInkExplosion(this.field_70170_p, this.func_234616_v_(), DAMAGE_SOURCE, this.func_233580_cy_(), this.getProjectileSize() * 0.85f, this.damage, this.splashDamage, this.damageMobs, this.getColor(), this.inkType, this.sourceWeapon);
            if (this.explodes) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SplatcraftSounds.blasterExplosion, SoundCategory.PLAYERS, 0.8f, ((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
            }
            this.func_70106_y();
        }
        if (this.trailSize > 0.0f && (float)this.field_70173_aa % this.trailCooldown == 0.0f) {
            for (double y = this.func_226278_cu_(); y >= 0.0 && this.func_226278_cu_() - y <= 8.0; y -= 1.0) {
                BlockPos inkPos = new BlockPos(this.func_226277_ct_(), y, this.func_226281_cx_());
                if (InkBlockUtils.canInkPassthrough(this.field_70170_p, inkPos)) continue;
                InkExplosion.createInkExplosion(this.field_70170_p, this.func_234616_v_(), DAMAGE_SOURCE, inkPos.func_177984_a(), this.trailSize, 0.0f, 0.0f, this.damageMobs, this.getColor(), this.inkType, this.sourceWeapon);
                InkExplosion.createInkExplosion(this.field_70170_p, this.func_234616_v_(), DAMAGE_SOURCE, this.func_233580_cy_(), this.trailSize, 0.0f, 0.0f, this.damageMobs, this.getColor(), this.inkType, this.sourceWeapon);
                break;
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        Entity target = result.func_216348_a();
        if (!this.canPierce) {
            if (target instanceof LivingEntity) {
                InkDamageUtils.doSplatDamage(this.field_70170_p, (LivingEntity)target, this.damage, this.getColor(), this.func_234616_v_(), this.sourceWeapon, this.damageMobs, this.inkType);
            }
            this.func_70106_y();
        }
    }

    protected void onBlockHit(BlockRayTraceResult result) {
        if (InkBlockUtils.canInkPassthrough(this.field_70170_p, result.func_216350_a())) {
            return;
        }
        this.func_230299_a_(result);
        InkExplosion.createInkExplosion(this.field_70170_p, this.func_234616_v_(), DAMAGE_SOURCE, this.func_233580_cy_(), this.getProjectileSize() * 0.85f, this.damage, this.splashDamage, this.damageMobs, this.getColor(), this.inkType, this.sourceWeapon);
        if (this.explodes) {
            this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), SplatcraftSounds.blasterExplosion, SoundCategory.PLAYERS, 0.8f, ((this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
        }
        this.func_70106_y();
    }

    public void shoot(Entity thrower, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        this.func_234612_a_(thrower, pitch, yaw, pitchOffset, velocity, inaccuracy);
        Vector3d posDiff = new Vector3d(0.0, 0.0, 0.0);
        if (thrower instanceof PlayerEntity) {
            try {
                posDiff = thrower.func_213303_ch().func_178788_d(WeaponHandler.getPlayerPrevPos((PlayerEntity)thrower));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        this.func_70107_b(this.func_226277_ct_() + posDiff.func_82615_a(), this.func_226278_cu_() + posDiff.func_82617_b(), this.func_226281_cx_() + posDiff.func_82616_c());
        this.func_213317_d(this.func_213322_ci().func_178787_e(posDiff.func_216372_d(0.8, 0.8, 0.8)));
    }

    protected void func_70227_a(RayTraceResult result) {
        RayTraceResult.Type rayType = result.func_216346_c();
        if (rayType == RayTraceResult.Type.ENTITY) {
            this.func_213868_a((EntityRayTraceResult)result);
        } else if (rayType == RayTraceResult.Type.BLOCK) {
            this.onBlockHit((BlockRayTraceResult)result);
        }
    }

    public void func_70037_a(CompoundNBT nbt) {
        this.setProjectileSize(nbt.func_74760_g("Size"));
        this.setColor(nbt.func_74762_e("Color"));
        this.gravityVelocity = nbt.func_74760_g("GravityVelocity");
        this.lifespan = nbt.func_74762_e("Lifespan");
        this.damage = nbt.func_74760_g("Damage");
        this.splashDamage = nbt.func_74760_g("SplashDamage");
        this.damageMobs = nbt.func_74767_n("DamageMobs");
        this.canPierce = nbt.func_74767_n("CanPierce");
        this.explodes = nbt.func_74767_n("Explodes");
        this.inkType = InkBlockUtils.InkType.values.get(nbt.func_74762_e("InkType"));
        this.sourceWeapon = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("SourceWeapon"));
    }

    public void func_213281_b(CompoundNBT nbt) {
        nbt.func_74776_a("Size", this.getProjectileSize());
        nbt.func_74768_a("Color", this.getColor());
        nbt.func_74776_a("GravityVelocity", this.gravityVelocity);
        nbt.func_74768_a("Lifespan", this.lifespan);
        nbt.func_74776_a("Damage", this.damage);
        nbt.func_74776_a("SplashDamage", this.splashDamage);
        nbt.func_74757_a("DamageMobs", this.damageMobs);
        nbt.func_74757_a("CanPierce", this.canPierce);
        nbt.func_74757_a("Explodes", this.explodes);
        nbt.func_74768_a("InkType", this.inkType.getIndex());
        nbt.func_218657_a("SourceWeapon", (INBT)this.sourceWeapon.func_77955_b(new CompoundNBT()));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntitySize func_213305_a(Pose pose) {
        return super.func_213305_a(pose).func_220313_a(this.getProjectileSize() / 2.0f);
    }

    public float func_70185_h() {
        return this.gravityVelocity;
    }

    public float getProjectileSize() {
        return ((Float)this.field_70180_af.func_187225_a(PROJ_SIZE)).floatValue();
    }

    public void setProjectileSize(float size) {
        this.field_70180_af.func_187227_b(PROJ_SIZE, (Object)Float.valueOf(size));
        this.func_226264_Z_();
        this.func_213323_x_();
    }

    @Override
    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }
}

