/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.entities;

import com.cibernet.splatcraft.entities.IColoredEntity;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkDamageUtils;
import java.util.Collections;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class SquidBumperEntity
extends LivingEntity
implements IColoredEntity {
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(SlimeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RESPAWN_TIME = EntityDataManager.func_187226_a(SquidBumperEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SPLAT_HEALTH = EntityDataManager.func_187226_a(SquidBumperEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final float maxInkHealth = 20.0f;
    public static final int maxRespawnTime = 60;
    public boolean inkproof = false;
    public long punchCooldown;
    public long hurtCooldown;

    public SquidBumperEntity(EntityType<? extends LivingEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public static AttributeModifierMap.MutableAttribute setCustomAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, 0.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR, (Object)2039597);
        this.field_70180_af.func_187214_a(SPLAT_HEALTH, (Object)Float.valueOf(20.0f));
        this.field_70180_af.func_187214_a(RESPAWN_TIME, (Object)60);
    }

    public void func_70636_d() {
        InkColorTileEntity te;
        super.func_70636_d();
        this.field_70172_ad = Math.max(this.field_70172_ad - 1, 0);
        if (this.getRespawnTime() > 1) {
            this.setRespawnTime(this.getRespawnTime() - 1);
        } else if (this.getRespawnTime() == 1) {
            this.respawn();
        }
        BlockPos pos = this.func_226270_aj_();
        if (this.field_70170_p.func_180495_p(pos).func_177230_c() == SplatcraftBlocks.inkwell && this.field_70170_p.func_175625_s(pos) instanceof InkColorTileEntity && (te = (InkColorTileEntity)this.field_70170_p.func_175625_s(pos)).getColor() != this.getColor()) {
            this.setColor(te.getColor());
        }
    }

    @Override
    public boolean onEntityInked(InkDamageUtils.InkDamageSource source, float damage) {
        if (!this.inkproof) {
            this.ink(damage);
            if (this.getInkHealth() <= 0.0f) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)34);
            }
        }
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            if (DamageSource.field_76380_i.equals(source)) {
                this.func_70106_y();
                return false;
            }
            if (!this.func_180431_b(source)) {
                if (source.func_94541_c()) {
                    this.dropBumper();
                    this.func_70106_y();
                    return false;
                }
                if (DamageSource.field_76372_a.equals(source)) {
                    if (this.func_70027_ad()) {
                        this.damageBumper(source, 0.15f);
                    } else {
                        this.func_70015_d(5);
                    }
                    return false;
                }
                if (DamageSource.field_76370_b.equals(source) && this.func_110143_aJ() > 0.5f) {
                    this.damageBumper(source, 4.0f);
                    return false;
                }
                boolean flag = source.func_76364_f() instanceof AbstractArrowEntity;
                boolean flag1 = flag && ((AbstractArrowEntity)source.func_76364_f()).func_213874_s() > 0;
                boolean flag2 = "player".equals(source.func_76355_l());
                if (!flag2 && !flag) {
                    return false;
                }
                if (source.func_76346_g() instanceof PlayerEntity && !((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75099_e) {
                    return false;
                }
                if (source.func_180136_u()) {
                    this.playBrokenSound();
                    this.playParticles();
                    this.func_70106_y();
                    return flag1;
                }
                long i = this.field_70170_p.func_82737_E();
                if (i - this.punchCooldown > 5L && !flag) {
                    this.field_70170_p.func_72960_a((Entity)this, (byte)32);
                    this.punchCooldown = i;
                } else {
                    this.dropBumper();
                    this.playParticles();
                    this.func_70106_y();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private void playParticles() {
        if (this.field_70170_p instanceof ServerWorld) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_196556_aL.func_176223_P()), this.func_226277_ct_(), this.func_226283_e_(0.6666666666666666), this.func_226281_cx_(), 10, (double)(this.func_213311_cf() / 4.0f), (double)(this.func_213302_cg() / 4.0f), (double)(this.func_213311_cf() / 4.0f), 0.05);
        }
    }

    private void playPopParticles() {
    }

    private void playBrokenSound() {
        this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187701_j, this.func_184176_by(), 1.0f, 1.0f);
    }

    private void damageBumper(DamageSource source, float dmg) {
        float f = this.func_110143_aJ();
        if ((f -= dmg) <= 0.5f) {
            this.dropBumper();
            this.func_70106_y();
        } else {
            this.func_70606_j(f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 31: {
                if (!this.field_70170_p.field_72995_K) break;
                this.hurtCooldown = this.field_70170_p.func_82737_E();
                break;
            }
            case 32: {
                if (!this.field_70170_p.field_72995_K) break;
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187707_l, this.func_184176_by(), 0.3f, 1.0f, false);
                this.punchCooldown = this.field_70170_p.func_82737_E();
                break;
            }
            case 34: {
                if (!this.field_70170_p.field_72995_K) break;
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, this.func_184176_by(), 0.5f, 20.0f, false);
                this.playPopParticles();
                break;
            }
            default: {
                super.func_70103_a(id);
            }
        }
    }

    public boolean func_70067_L() {
        return this.getInkHealth() > 0.0f;
    }

    protected void func_82167_n(Entity entityIn) {
        if (this.getInkHealth() > 0.0f) {
            this.func_70108_f(entityIn);
        }
    }

    public void func_70108_f(Entity entityIn) {
        double d1;
        double d0;
        double d2;
        if (!this.func_184223_x(entityIn) && !entityIn.field_70145_X && !this.field_70145_X && (d2 = MathHelper.func_76132_a((double)(d0 = entityIn.func_226277_ct_() - this.func_226277_ct_()), (double)(d1 = entityIn.func_226281_cx_() - this.func_226281_cx_()))) >= (double)0.01f) {
            d2 = MathHelper.func_76133_a((double)d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.05f;
            d1 *= (double)0.05f;
            d0 *= (double)(1.0f - this.field_70144_Y);
            d1 *= (double)(1.0f - this.field_70144_Y);
            d0 *= 3.0;
            d1 *= 3.0;
            if (!entityIn.func_184207_aI()) {
                entityIn.func_70024_g(d0, 0.0, d1);
            }
        }
    }

    public void dropBumper() {
        Block.func_180635_a((World)this.field_70170_p, (BlockPos)this.func_233580_cy_(), (ItemStack)ColorUtils.setInkColor(new ItemStack((IItemProvider)SplatcraftItems.squidBumper), this.getColor()));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ColorUtils.setColorLocked(ColorUtils.setInkColor(new ItemStack((IItemProvider)SplatcraftItems.squidBumper), this.getColor()), true);
    }

    public Iterable<ItemStack> func_184193_aE() {
        return Collections.EMPTY_LIST;
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
    }

    public HandSide func_184591_cq() {
        return HandSide.RIGHT;
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("Color")) {
            this.setColor(nbt.func_74762_e("Color"));
        } else {
            this.setColor(ColorUtils.getRandomStarterColor());
        }
        if (nbt.func_74764_b("Inkproof")) {
            this.inkproof = nbt.func_74767_n("Inkproof");
        }
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("Color", this.getColor());
        if (this.inkproof) {
            nbt.func_74757_a("Inkproof", this.inkproof);
        }
    }

    @Override
    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color);
    }

    public float getInkHealth() {
        return ((Float)this.field_70180_af.func_187225_a(SPLAT_HEALTH)).floatValue();
    }

    public void setInkHealth(float value) {
        this.field_70180_af.func_187227_b(SPLAT_HEALTH, (Object)Float.valueOf(value));
    }

    public int getRespawnTime() {
        return (Integer)this.field_70180_af.func_187225_a(RESPAWN_TIME);
    }

    public void setRespawnTime(int value) {
        this.field_70180_af.func_187227_b(RESPAWN_TIME, (Object)value);
    }

    public void ink(float damage) {
        this.setInkHealth(this.getInkHealth() - damage);
        this.setRespawnTime(60);
        this.field_70170_p.func_72960_a((Entity)this, (byte)31);
        this.hurtCooldown = this.field_70170_p.func_82737_E();
        this.field_70172_ad = 20;
    }

    public void respawn() {
        if (this.getInkHealth() <= 0.0f) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_193808_ex, this.func_184176_by(), 1.0f, 4.0f);
        }
        this.setInkHealth(20.0f);
        this.setRespawnTime(0);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

