/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.items.weapons.SlosherItem;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.mrcrayfish.obfuscate.client.event.PlayerModelEvent;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerPosingHandler {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void setupPlayerAngles(PlayerModelEvent.SetupAngles.Post event) {
        PlayerEntity player = event.getPlayer();
        PlayerModel model = event.getModelPlayer();
        if (model == null || player == null || PlayerInfoCapability.isSquid((LivingEntity)player)) {
            return;
        }
        IPlayerInfo playerInfo = PlayerInfoCapability.get((LivingEntity)player);
        Hand activeHand = player.func_184600_cs();
        HandSide handSide = player.func_184591_cq();
        if (activeHand == null) {
            return;
        }
        ModelRenderer mainHand = activeHand == Hand.MAIN_HAND && handSide == HandSide.LEFT || activeHand == Hand.OFF_HAND && handSide == HandSide.RIGHT ? model.field_178724_i : model.field_178723_h;
        ModelRenderer offHand = mainHand.equals(model.field_178724_i) ? model.field_178723_h : model.field_178724_i;
        ItemStack mainStack = player.func_184586_b(activeHand);
        ItemStack offStack = player.func_184586_b(Hand.values()[(activeHand.ordinal() + 1) % Hand.values().length]);
        int useTime = player.func_184605_cv();
        if (!(mainStack.func_77973_b() instanceof WeaponBaseItem)) {
            return;
        }
        if (useTime > 0 || playerInfo.getPlayerCooldown() != null && playerInfo.getPlayerCooldown().getTime() > 0) {
            useTime = mainStack.func_77973_b().func_77626_a(mainStack) - useTime;
            switch (((WeaponBaseItem)mainStack.func_77973_b()).getPose()) {
                case DUAL_FIRE: {
                    if (offStack.func_77973_b() instanceof WeaponBaseItem && ((WeaponBaseItem)offStack.func_77973_b()).getPose().equals((Object)WeaponPose.DUAL_FIRE)) {
                        offHand.field_78796_g = -0.1f + model.func_205072_a().field_78796_g;
                        offHand.field_78795_f = -1.5707964f + model.func_205072_a().field_78795_f;
                    }
                }
                case FIRE: {
                    mainHand.field_78796_g = -0.1f + model.func_205072_a().field_78796_g;
                    mainHand.field_78795_f = -1.5707964f + model.func_205072_a().field_78795_f;
                    break;
                }
                case BUCKET_SWING: {
                    float animTime = (float)((SlosherItem)mainStack.func_77973_b()).startupTicks * 0.5f;
                    mainHand.field_78796_g = 0.0f;
                    mainHand.field_78795_f = -0.36f;
                    float angle = (float)useTime / animTime;
                    if (!(angle < 6.5f)) break;
                    mainHand.field_78795_f = MathHelper.func_76134_b((float)(angle * 0.6662f));
                }
            }
        }
    }

    public static enum WeaponPose {
        NONE,
        FIRE,
        DUAL_FIRE,
        ROLL,
        BOW_CHARGE,
        BUCKET_SWING;

    }
}

