/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers;

import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import com.cibernet.splatcraft.items.InkTankItem;
import com.cibernet.splatcraft.network.RequestPlayerInfoPacket;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.network.UpdateBooleanGamerulesPacket;
import com.cibernet.splatcraft.network.UpdateColorScoresPacket;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.util.PlayerCooldown;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.NonNullList;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SplatcraftCommonHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity player = event.getPlayer();
        PlayerInfoCapability.get((LivingEntity)player).readNBT(PlayerInfoCapability.get((LivingEntity)event.getOriginal()).writeNBT(new CompoundNBT()));
        NonNullList<ItemStack> matchInv = PlayerInfoCapability.get((LivingEntity)player).getMatchInventory();
        if (!matchInv.isEmpty()) {
            for (int i = 0; i < matchInv.size(); ++i) {
                ItemStack stack = (ItemStack)matchInv.get(i);
                if (stack.func_190926_b() || SplatcraftCommonHandler.putStackInSlot(player.field_71071_by, stack, i) || player.field_71071_by.func_70441_a(stack)) continue;
                player.func_146097_a(stack, true, true);
            }
            PlayerInfoCapability.get((LivingEntity)player).setMatchInventory((NonNullList<ItemStack>)NonNullList.func_191196_a());
        }
        PlayerCooldown.setPlayerCooldown(player, null);
    }

    private static boolean putStackInSlot(PlayerInventory inventory, ItemStack stack, int i) {
        ItemStack invStack = inventory.func_70301_a(i);
        if (invStack.func_190926_b()) {
            inventory.func_70299_a(i, stack);
            return true;
        }
        if (invStack.func_77969_a(stack)) {
            int invCount = invStack.func_190916_E();
            int count = Math.min(invStack.func_77976_d(), stack.func_190916_E() + invStack.func_190916_E());
            invStack.func_190920_e(count);
            stack.func_190918_g(count - invCount);
            return stack.func_190926_b();
        }
        return false;
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = entity.func_184582_a(EquipmentSlotType.CHEST);
        if (stack.func_77973_b() instanceof InkTankItem) {
            ((InkTankItem)stack.func_77973_b()).refill(stack);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeathDrops(LivingDropsEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            NonNullList<ItemStack> matchInv = PlayerInfoCapability.get((LivingEntity)player).getMatchInventory();
            for (ItemEntity drop : new ArrayList(event.getDrops())) {
                if (!matchInv.contains((Object)drop.func_92059_d())) continue;
                event.getDrops().remove(drop);
            }
            for (int i = 0; i < matchInv.size(); ++i) {
                ItemStack stack = (ItemStack)matchInv.get(i);
                if (stack.func_190926_b() || SplatcraftCommonHandler.putStackInSlot(player.field_71071_by, stack, i)) continue;
                player.field_71071_by.func_70441_a(stack);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerAboutToDie(LivingDamageEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity) || event.getEntityLiving().func_110143_aJ() - event.getAmount() > 0.0f) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        if (!player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && SplatcraftGameRules.getBooleanRuleValue(player.field_70170_p, SplatcraftGameRules.KEEP_MATCH_ITEMS)) {
            IPlayerInfo playerCapability;
            try {
                playerCapability = PlayerInfoCapability.get((LivingEntity)player);
            }
            catch (NullPointerException e) {
                return;
            }
            if (playerCapability == null) {
                return;
            }
            NonNullList matchInv = NonNullList.func_191197_a((int)player.field_71071_by.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < matchInv.size(); ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (!SplatcraftTags.Items.MATCH_ITEMS.func_230235_a_((Object)stack.func_77973_b())) continue;
                matchInv.set(i, (Object)stack);
            }
            playerCapability.setMatchInventory((NonNullList<ItemStack>)matchInv);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        SplatcraftPacketHandler.sendToPlayer(new UpdateBooleanGamerulesPacket(SplatcraftGameRules.booleanRules), (ServerPlayerEntity)player);
        int[] colors = new int[ScoreboardHandler.getCriteriaKeySet().size()];
        int i = 0;
        for (int c : ScoreboardHandler.getCriteriaKeySet()) {
            colors[i++] = c;
        }
        SplatcraftPacketHandler.sendToPlayer(new UpdateColorScoresPacket(true, true, colors), (ServerPlayerEntity)player);
    }

    @SubscribeEvent
    public static void onDataReload(AddReloadListenerEvent event) {
    }

    @SubscribeEvent
    public static void capabilityUpdateEvent(TickEvent.PlayerTickEvent event) {
        try {
            if (event.player.field_70725_aQ <= 0 && !PlayerInfoCapability.get((LivingEntity)event.player).isInitialized()) {
                if (event.player.field_70170_p.field_72995_K) {
                    SplatcraftPacketHandler.sendToServer(new RequestPlayerInfoPacket(event.player));
                }
                PlayerInfoCapability.get((LivingEntity)event.player).setInitialized(true);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public static void gameruleUpdateEvent(TickEvent.WorldTickEvent event) {
        World world = event.world;
        if (world.field_72995_K) {
            return;
        }
        for (Map.Entry<Integer, Boolean> rule : SplatcraftGameRules.booleanRules.entrySet()) {
            boolean worldValue = world.func_82736_K().func_223586_b(SplatcraftGameRules.getRuleFromIndex(rule.getKey()));
            if (rule.getValue() == worldValue) continue;
            SplatcraftGameRules.booleanRules.put(rule.getKey(), worldValue);
            SplatcraftPacketHandler.sendToAll(new UpdateBooleanGamerulesPacket((GameRules.RuleKey<GameRules.BooleanValue>)SplatcraftGameRules.getRuleFromIndex(rule.getKey()), rule.getValue()));
        }
    }
}

