/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers;

import com.cibernet.splatcraft.blocks.InkwellBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.IPlayerInfo;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.registries.SplatcraftStats;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.InkDamageUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.Difficulty;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class SquidFormHandler {
    private static Map<PlayerEntity, Integer> squidSubmergeMode = new LinkedHashMap<PlayerEntity, Integer>();

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (InkBlockUtils.onEnemyInk((LivingEntity)player) && player.field_70173_aa % 20 == 0 && player.func_110143_aJ() > 4.0f && player.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
            player.func_70097_a(InkDamageUtils.ENEMY_INK, 2.0f);
        }
        if (player.field_70170_p.func_82736_K().func_223586_b(SplatcraftGameRules.WATER_DAMAGE) && player.func_70090_H() && player.field_70173_aa % 10 == 0) {
            player.func_70097_a(InkDamageUtils.WATER, 8.0f);
        }
        IPlayerInfo info = PlayerInfoCapability.get((LivingEntity)player);
        if (event.phase == TickEvent.Phase.START) {
            if (!squidSubmergeMode.containsKey(player)) {
                squidSubmergeMode.put(player, -2);
            }
            if (info.isSquid() && InkBlockUtils.canSquidHide((LivingEntity)player)) {
                player.func_82142_c(true);
            }
            if (InkBlockUtils.canSquidSwim((LivingEntity)player) && info.isSquid()) {
                squidSubmergeMode.put(player, Math.min(2, Math.max(squidSubmergeMode.get(player) + 1, 1)));
            } else {
                squidSubmergeMode.put(player, Math.max(-2, Math.min(squidSubmergeMode.get(player) - 1, -1)));
            }
            if (squidSubmergeMode.get(player) == 1) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SplatcraftSounds.inkSubmerge, SoundCategory.PLAYERS, 0.75f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
            } else if (squidSubmergeMode.get(player) == -1) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SplatcraftSounds.inkSurface, SoundCategory.PLAYERS, 0.75f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
            }
        } else if (!InkBlockUtils.canSquidSwim((LivingEntity)player) || !info.isSquid()) {
            player.func_82142_c(SquidFormHandler.shouldBeInvisible(player));
        }
        if (PlayerInfoCapability.isSquid((LivingEntity)player)) {
            player.func_213301_b(Pose.FALL_FLYING);
            player.func_184597_cx();
            player.func_195066_a(SplatcraftStats.SQUID_TIME);
            if (InkBlockUtils.canSquidSwim((LivingEntity)player)) {
                player.field_70143_R = 0.0f;
                if (player.field_70173_aa % 5 == 0 && player.func_70660_b(Effects.field_76436_u) == null && player.func_70660_b(Effects.field_82731_v) == null) {
                    player.func_70691_i(0.5f);
                }
            }
            if (player.field_70170_p.func_180495_p(player.func_233580_cy_().func_177977_b()).func_177230_c() instanceof InkwellBlock) {
                InkColorTileEntity inkwell = (InkColorTileEntity)player.field_70170_p.func_175625_s(player.func_233580_cy_().func_177977_b());
                ColorUtils.setPlayerColor(player, inkwell.getColor());
            }
        }
    }

    protected static boolean shouldBeInvisible(PlayerEntity playerEntity) {
        return playerEntity.func_70644_a(Effects.field_76441_p);
    }

    @SubscribeEvent
    public static void playerVisibility(PlayerEvent.Visibility event) {
        if (PlayerInfoCapability.get((LivingEntity)event.getPlayer()).isSquid() && InkBlockUtils.canSquidHide((LivingEntity)event.getPlayer())) {
            event.modifyVisibility(0.0);
        }
    }

    @SubscribeEvent
    public static void playerBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (PlayerInfoCapability.isSquid((LivingEntity)event.getPlayer())) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public static void onPlayerAttackEntity(AttackEntityEvent event) {
        if (PlayerInfoCapability.isSquid((LivingEntity)event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerInteract(PlayerInteractEvent event) {
        if (PlayerInfoCapability.isSquid((LivingEntity)event.getPlayer()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }
}

