/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers;

import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.PlayerCharge;
import com.cibernet.splatcraft.util.PlayerCooldown;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="splatcraft")
public class WeaponHandler {
    private static Map<PlayerEntity, Vector3d> prevPosMap = new LinkedHashMap<PlayerEntity, Vector3d>();

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        PlayerEntity target;
        if (event.getEntityLiving() instanceof PlayerEntity && (target = (PlayerEntity)event.getEntityLiving()).func_110143_aJ() > 0.0f && target.func_110143_aJ() - event.getAmount() <= 0.0f) {
            PlayerEntity source;
            if (ScoreboardHandler.hasColorCriterion(ColorUtils.getPlayerColor(target))) {
                target.func_96123_co().func_197893_a((ScoreCriteria)ScoreboardHandler.getDeathsAsColor(ColorUtils.getPlayerColor(target)), target.func_195047_I_(), score -> score.func_96649_a(1));
            }
            if (event.getSource().func_76364_f() instanceof PlayerEntity && ScoreboardHandler.hasColorCriterion(ColorUtils.getPlayerColor(source = (PlayerEntity)event.getSource().func_76346_g()))) {
                target.func_96123_co().func_197893_a((ScoreCriteria)ScoreboardHandler.getColorKills(ColorUtils.getPlayerColor(target)), source.func_195047_I_(), score -> score.func_96649_a(1));
                target.func_96123_co().func_197893_a((ScoreCriteria)ScoreboardHandler.getKillsAsColor(ColorUtils.getPlayerColor(source)), source.func_195047_I_(), score -> score.func_96649_a(1));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        PlayerEntity player = event.player;
        if (PlayerCooldown.hasPlayerCooldown(player)) {
            player.field_71071_by.field_70461_c = PlayerCooldown.getPlayerCooldown(player).getSlotIndex();
        }
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        boolean canUseWeapon = true;
        if (PlayerCooldown.shrinkCooldownTime(player, 1) != null) {
            ItemStack stack;
            PlayerCooldown cooldown = PlayerCooldown.getPlayerCooldown(player);
            PlayerInfoCapability.get((LivingEntity)player).setIsSquid(false);
            boolean bl = canUseWeapon = !cooldown.preventWeaponUse();
            if (cooldown.getTime() == 1 && player.func_184600_cs() != null && (stack = player.func_184586_b(player.func_184600_cs())).func_77973_b() instanceof WeaponBaseItem) {
                ((WeaponBaseItem)stack.func_77973_b()).onPlayerCooldownEnd(player.field_70170_p, player, stack);
            }
        }
        if (canUseWeapon && player.func_184600_cs() != null && player.func_184605_cv() > 0) {
            ItemStack stack = player.func_184586_b(player.func_184600_cs());
            if (stack.func_77973_b() instanceof WeaponBaseItem) {
                ((WeaponBaseItem)stack.func_77973_b()).weaponUseTick(player.field_70170_p, (LivingEntity)player, stack, player.func_184605_cv());
            }
        } else if (PlayerCharge.canDischarge(player) || PlayerInfoCapability.isSquid((LivingEntity)player)) {
            PlayerCharge.dischargeWeapon(player);
        }
        prevPosMap.put(player, player.func_213303_ch());
    }

    public static Vector3d getPlayerPrevPos(PlayerEntity player) {
        return prevPosMap.get(player);
    }
}

