/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers.client;

import com.cibernet.splatcraft.client.gui.InkVatScreen;
import com.cibernet.splatcraft.client.gui.WeaponWorkbenchScreen;
import com.cibernet.splatcraft.registries.SplatcraftBlocks;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.registries.SplatcraftTileEntitites;
import com.cibernet.splatcraft.util.ColorUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="splatcraft", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientSetupHandler {
    @SubscribeEvent
    public static void onTextureStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        event.addSprite(new ResourceLocation("splatcraft", "blocks/stage_barrier_fancy"));
        event.addSprite(new ResourceLocation("splatcraft", "blocks/stage_void_fancy"));
    }

    public static void bindScreenContainers() {
        ScreenManager.func_216911_a(SplatcraftTileEntitites.inkVatContainer, InkVatScreen::new);
        ScreenManager.func_216911_a(SplatcraftTileEntitites.weaponWorkbenchContainer, WeaponWorkbenchScreen::new);
    }

    @SubscribeEvent
    public static void initItemColors(ColorHandlerEvent.Item event) {
        ItemColors colors = event.getItemColors();
        colors.func_199877_a((IItemColor)new InkItemColor(), (IItemProvider[])SplatcraftItems.inkColoredItems.toArray(new Item[SplatcraftItems.inkColoredItems.size()]));
    }

    @SubscribeEvent
    public static void initBlockColors(ColorHandlerEvent.Block event) {
        BlockColors colors = event.getBlockColors();
        colors.func_186722_a((IBlockColor)new InkBlockColor(), SplatcraftBlocks.inkColoredBlocks.toArray(new Block[SplatcraftBlocks.inkColoredBlocks.size()]));
    }

    protected static class InkBlockColor
    implements IBlockColor {
        protected InkBlockColor() {
        }

        public int getColor(BlockState blockState, @Nullable IBlockDisplayReader iBlockDisplayReader, @Nullable BlockPos blockPos, int i) {
            if (iBlockDisplayReader == null) {
                return -1;
            }
            int color = ColorUtils.getInkColor(iBlockDisplayReader.func_175625_s(blockPos));
            if (color == -1) {
                return 0xFFFFFF;
            }
            return color;
        }
    }

    protected static class InkItemColor
    implements IItemColor {
        protected InkItemColor() {
        }

        public int getColor(ItemStack stack, int i) {
            return i == 0 ? ColorUtils.getInkColor(stack) : -1;
        }
    }
}

