/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers.client;

import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.PlayerCooldown;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MovementInput;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputUpdateEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PlayerMovementHandler {
    private static final AttributeModifier INK_SWIM_SPEED = new AttributeModifier("Ink swimming speed boost", 0.0, AttributeModifier.Operation.ADDITION);
    private static final AttributeModifier SQUID_SWIM_SPEED = new AttributeModifier("Squid swim speed boost", 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private static final AttributeModifier ENEMY_INK_SPEED = new AttributeModifier("Enemy ink speed penalty", -0.5, AttributeModifier.Operation.MULTIPLY_TOTAL);

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void playerMovement(TickEvent.PlayerTickEvent event) {
        if (!(event.player instanceof ClientPlayerEntity) || event.phase != TickEvent.Phase.END) {
            return;
        }
        ClientPlayerEntity player = (ClientPlayerEntity)event.player;
        ModifiableAttributeInstance speedAttribute = player.func_110148_a(Attributes.field_233821_d_);
        ModifiableAttributeInstance swimAttribute = player.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get());
        if (speedAttribute.func_180374_a(INK_SWIM_SPEED) && player.func_233570_aj_()) {
            speedAttribute.func_111124_b(INK_SWIM_SPEED);
        }
        if (speedAttribute.func_180374_a(ENEMY_INK_SPEED)) {
            speedAttribute.func_111124_b(ENEMY_INK_SPEED);
        }
        if (swimAttribute.func_180374_a(SQUID_SWIM_SPEED)) {
            swimAttribute.func_111124_b(SQUID_SWIM_SPEED);
        }
        if (InkBlockUtils.onEnemyInk((LivingEntity)player)) {
            player.func_213293_j(player.func_213322_ci().field_72450_a, Math.min(player.func_213322_ci().field_72448_b, (double)0.05f), player.func_213322_ci().field_72449_c);
            if (!speedAttribute.func_180374_a(ENEMY_INK_SPEED)) {
                speedAttribute.func_233767_b_(ENEMY_INK_SPEED);
            }
        }
        if (PlayerInfoCapability.isSquid((LivingEntity)player)) {
            if (InkBlockUtils.canSquidSwim((LivingEntity)player) && !speedAttribute.func_180374_a(INK_SWIM_SPEED)) {
                speedAttribute.func_233767_b_(INK_SWIM_SPEED);
            }
            if (!swimAttribute.func_180374_a(SQUID_SWIM_SPEED)) {
                swimAttribute.func_233767_b_(SQUID_SWIM_SPEED);
            }
        }
        if (PlayerCooldown.hasPlayerCooldown((PlayerEntity)player)) {
            PlayerCooldown cooldown = PlayerCooldown.getPlayerCooldown((PlayerEntity)player);
            player.field_71071_by.field_70461_c = cooldown.getSlotIndex();
        }
        if (!player.field_71075_bZ.field_75100_b && speedAttribute.func_180374_a(INK_SWIM_SPEED)) {
            player.func_213309_a((float)player.func_233637_b_(SplatcraftItems.INK_SWIM_SPEED) * (player.func_233570_aj_() ? 1.0f : 0.2f), new Vector3d((double)player.field_70702_br, 0.0, (double)player.field_191988_bg));
        }
    }

    @SubscribeEvent
    public static void onInputUpdate(InputUpdateEvent event) {
        ItemStack stack;
        MovementInput input = event.getMovementInput();
        PlayerEntity player = event.getPlayer();
        float speedMod = InkBlockUtils.canSquidHide((LivingEntity)player) ? 20.0f : 2.0f;
        input.field_192832_b *= speedMod;
        input.field_78902_a *= speedMod;
        if (PlayerInfoCapability.isSquid((LivingEntity)player) && InkBlockUtils.canSquidClimb((LivingEntity)player) && !player.field_71075_bZ.field_75100_b) {
            double xOff = (double)Math.signum(player.func_174811_aO().func_82601_c() == 0 ? player.field_70702_br : player.field_191988_bg) * 0.1 * (double)player.func_174811_aO().func_176743_c().func_179524_a();
            double zOff = (double)Math.signum(player.func_174811_aO().func_82599_e() == 0 ? player.field_70702_br : player.field_191988_bg) * 0.1 * (double)player.func_174811_aO().func_176743_c().func_179524_a();
            double d = player.func_213322_ci().func_82617_b();
            float f = input.field_78901_c ? 0.46f : 0.4f;
            if (d < (double)f) {
                player.func_213309_a(0.055f * (input.field_78901_c ? 1.9f : 1.7f), new Vector3d(0.0, (double)player.field_191988_bg, 0.0));
            }
            if (player.func_213322_ci().func_82617_b() <= 0.0 && !player.func_225608_bj_()) {
                player.func_213309_a(0.035f, new Vector3d(0.0, 1.0, 0.0));
            }
            if (player.func_225608_bj_()) {
                player.func_213293_j(player.func_213322_ci().field_72450_a, Math.max(0.0, player.func_213322_ci().func_82617_b()), player.func_213322_ci().field_72449_c);
            }
        }
        if (player.func_184587_cr() && !(stack = player.func_184607_cu()).func_190926_b() && stack.func_77973_b() instanceof WeaponBaseItem) {
            input.field_78902_a *= 5.0f;
            input.field_192832_b *= 5.0f;
        }
        if (PlayerCooldown.hasPlayerCooldown(player)) {
            PlayerCooldown cooldown = PlayerCooldown.getPlayerCooldown(player);
            if (!cooldown.canMove()) {
                input.field_192832_b = 0.0f;
                input.field_78902_a = 0.0f;
                input.field_78901_c = false;
            }
            if (cooldown.forceCrouch() && cooldown.getTime() > 1) {
                input.field_228350_h_ = !player.field_71075_bZ.field_75100_b;
            }
        }
    }
}

