/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.handlers.client;

import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.client.renderer.PlayerSquidRenderer;
import com.cibernet.splatcraft.registries.SplatcraftGameRules;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.PlayerCooldown;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.obfuscate.client.event.RenderItemEvent;
import java.util.ArrayList;
import java.util.TreeMap;
import net.minecraft.block.Block;
import net.minecraft.block.BreakableBlock;
import net.minecraft.block.StainedGlassPaneBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class RendererHandler {
    public static final ArrayList<ResourceLocation> textures = new ArrayList();
    private static PlayerSquidRenderer squidRenderer = null;
    private static float tickTime = 0.0f;
    private static float oldCooldown = 0.0f;
    @Deprecated
    public static final RenderState.TransparencyState TRANSLUCENT_TRANSPARENCY = new RenderState.TransparencyState("translucent_transparency", () -> {
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
    }, () -> {
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
    });

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerRender(RenderPlayerEvent event) {
        PlayerEntity player = event.getPlayer();
        if (PlayerInfoCapability.isSquid((LivingEntity)player)) {
            event.setCanceled(true);
            if (squidRenderer == null) {
                squidRenderer = new PlayerSquidRenderer(event.getRenderer().func_177068_d());
            }
            if (!InkBlockUtils.canSquidHide((LivingEntity)player)) {
                squidRenderer.func_225623_a_((LivingEntity)player, player.field_70759_as, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
            }
        }
    }

    @SubscribeEvent
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && PlayerCooldown.hasPlayerCooldown((PlayerEntity)player)) {
            player.field_71071_by.field_70461_c = PlayerCooldown.getPlayerCooldown((PlayerEntity)player).getSlotIndex();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void playerRenderPost(RenderPlayerEvent.Post event) {
    }

    @SubscribeEvent
    public static void renderHand(RenderHandEvent event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (PlayerInfoCapability.isSquid((LivingEntity)player)) {
            event.setCanceled(true);
            return;
        }
        if (PlayerCooldown.hasPlayerCooldown((PlayerEntity)player)) {
            PlayerCooldown cooldown = PlayerCooldown.getPlayerCooldown((PlayerEntity)player);
            float time = cooldown.getTime();
            float maxTime = cooldown.getMaxTime();
            if (time != oldCooldown) {
                oldCooldown = time;
                tickTime = 0.0f;
            }
            tickTime = (tickTime + 1.0f) % 10.0f;
            float yOff = -0.5f * (time / maxTime);
            event.getMatrixStack().func_227861_a_(0.0, (double)yOff, 0.0);
        } else {
            tickTime = 0.0f;
        }
    }

    @SubscribeEvent
    public static void onItemRenderGui(RenderItemEvent.Gui.Pre event) {
        if (event.getItem().func_77973_b().equals(SplatcraftItems.powerEgg)) {
            IBakedModel modelIn = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation(event.getItem().func_77973_b().getRegistryName() + "#inventory"));
            RendererHandler.renderItem(event.getItem(), event.getTransformType(), true, event.getMatrixStack(), event.getRenderTypeBuffer(), event.getLight(), event.getOverlay(), modelIn);
            event.setCanceled(true);
        }
    }

    protected static void renderItem(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn) {
        if (!itemStackIn.func_190926_b()) {
            boolean flag;
            ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
            matrixStackIn.func_227860_a_();
            boolean bl = flag = transformTypeIn == ItemCameraTransforms.TransformType.GUI || transformTypeIn == ItemCameraTransforms.TransformType.GROUND || transformTypeIn == ItemCameraTransforms.TransformType.FIXED;
            if (itemStackIn.func_77973_b() == Items.field_203184_eO && flag) {
                modelIn = itemRenderer.func_175037_a().func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident#inventory"));
            }
            modelIn = ForgeHooksClient.handleCameraTransforms((MatrixStack)matrixStackIn, (IBakedModel)modelIn, (ItemCameraTransforms.TransformType)transformTypeIn, (boolean)leftHand);
            matrixStackIn.func_227861_a_(-0.5, -0.5, -0.5);
            if (!modelIn.func_188618_c() && (itemStackIn.func_77973_b() != Items.field_203184_eO || flag)) {
                Block block;
                boolean flag1 = transformTypeIn != ItemCameraTransforms.TransformType.GUI && !transformTypeIn.func_241716_a_() && itemStackIn.func_77973_b() instanceof BlockItem ? !((block = ((BlockItem)itemStackIn.func_77973_b()).func_179223_d()) instanceof BreakableBlock) && !(block instanceof StainedGlassPaneBlock) : true;
                if (modelIn.isLayered()) {
                    ForgeHooksClient.drawItemLayered((ItemRenderer)itemRenderer, (IBakedModel)modelIn, (ItemStack)itemStackIn, (MatrixStack)matrixStackIn, (IRenderTypeBuffer)bufferIn, (int)combinedLightIn, (int)combinedOverlayIn, (boolean)flag1);
                } else {
                    IVertexBuilder ivertexbuilder;
                    RenderType rendertype = RendererHandler.getItemEntityTranslucent(PlayerContainer.field_226615_c_);
                    if (itemStackIn.func_77973_b() == Items.field_151111_aL && itemStackIn.func_77962_s()) {
                        matrixStackIn.func_227860_a_();
                        MatrixStack.Entry matrixstack$entry = matrixStackIn.func_227866_c_();
                        if (transformTypeIn == ItemCameraTransforms.TransformType.GUI) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.5f);
                        } else if (transformTypeIn.func_241716_a_()) {
                            matrixstack$entry.func_227870_a_().func_226592_a_(0.75f);
                        }
                        ivertexbuilder = flag1 ? ItemRenderer.func_241732_b_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry) : ItemRenderer.func_241731_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (MatrixStack.Entry)matrixstack$entry);
                        matrixStackIn.func_227865_b_();
                    } else {
                        ivertexbuilder = flag1 ? ItemRenderer.func_239391_c_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s()) : ItemRenderer.func_229113_a_((IRenderTypeBuffer)bufferIn, (RenderType)rendertype, (boolean)true, (boolean)itemStackIn.func_77962_s());
                    }
                    itemRenderer.func_229114_a_(modelIn, itemStackIn, combinedLightIn, combinedOverlayIn, matrixStackIn, ivertexbuilder);
                }
            } else {
                itemStackIn.func_77973_b().getItemStackTileEntityRenderer().func_239207_a_(itemStackIn, transformTypeIn, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
            }
            matrixStackIn.func_227865_b_();
        }
    }

    protected static RenderType getItemEntityTranslucent(ResourceLocation locationIn) {
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(locationIn, false, false)).func_228726_a_(TRANSLUCENT_TRANSPARENCY).func_228716_a_(new RenderState.DiffuseLightingState(true)).func_228713_a_(new RenderState.AlphaState(0.003921569f)).func_228719_a_(new RenderState.LightmapState(true)).func_228722_a_(new RenderState.OverlayState(true)).func_228728_a_(true);
        return RenderType.func_228633_a_((String)"item_entity_translucent", (VertexFormat)DefaultVertexFormats.field_227849_i_, (int)7, (int)256, (boolean)true, (boolean)false, (RenderType.State)rendertype$state);
    }

    @SubscribeEvent
    public static void onChatMessage(ClientChatReceivedEvent event) {
        if (SplatcraftGameRules.getBooleanRuleValue((World)Minecraft.func_71410_x().field_71441_e, SplatcraftGameRules.COLORED_PLAYER_NAMES) && event.getMessage() instanceof TranslationTextComponent) {
            TranslationTextComponent component = (TranslationTextComponent)event.getMessage();
            TreeMap players = Maps.newTreeMap();
            Minecraft.func_71410_x().field_71441_e.func_217369_A().forEach(player -> players.put(player.func_145748_c_().getString(), player));
            for (Object obj : component.func_150271_j()) {
                TextComponent msgChildren;
                String key;
                if (!(obj instanceof TextComponent) || !players.containsKey(key = (msgChildren = (TextComponent)obj).getString())) continue;
                msgChildren.func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)ColorUtils.getPlayerColor((PlayerEntity)players.get(key)))));
            }
        }
    }

    @SubscribeEvent
    public static void renderNameplate(RenderNameplateEvent event) {
        int color;
        if (SplatcraftGameRules.getBooleanRuleValue(event.getEntity().field_70170_p, SplatcraftGameRules.COLORED_PLAYER_NAMES) && event.getEntity() instanceof LivingEntity && (color = ColorUtils.getEntityColor((LivingEntity)event.getEntity())) != -1) {
            event.setContent((ITextComponent)((TextComponent)event.getContent()).func_230530_a_(Style.field_240709_b_.func_240718_a_(Color.func_240743_a_((int)color))));
        }
    }
}

