/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.blocks.InkwellBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ColoredArmorItem
extends ArmorItem
implements IDyeableArmorItem {
    public ColoredArmorItem(String name, IArmorMaterial material, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties);
        SplatcraftItems.inkColoredItems.add((Item)this);
        this.setRegistryName(name);
    }

    public ColoredArmorItem(String name, IArmorMaterial material, EquipmentSlotType slot) {
        this(name, material, slot, new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_WEAPONS).func_200917_a(1));
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (I18n.func_188566_a((String)(this.func_77658_a() + ".tooltip"))) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip").func_240699_a_(TextFormatting.GRAY));
        }
        if (ColorUtils.isColorLocked(stack)) {
            tooltip.add(ColorUtils.getFormatedColorName(ColorUtils.getInkColor(stack), true));
        } else if (I18n.func_188566_a((String)(this.func_77658_a() + ".colorless_tooltip"))) {
            tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".colorless_tooltip").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof PlayerEntity && !ColorUtils.isColorLocked(stack) && ColorUtils.getInkColor(stack) != ColorUtils.getPlayerColor((PlayerEntity)entity) && PlayerInfoCapability.hasCapability((LivingEntity)entity)) {
            ColorUtils.setInkColor(stack, ColorUtils.getPlayerColor((PlayerEntity)entity));
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        if (entity.field_70170_p.func_180495_p(pos).func_177230_c() instanceof InkwellBlock) {
            InkColorTileEntity te = (InkColorTileEntity)entity.field_70170_p.func_175625_s(pos);
            if (ColorUtils.getInkColor(stack) != ColorUtils.getInkColor(te)) {
                ColorUtils.setInkColor(entity.func_92059_d(), ColorUtils.getInkColor(te));
                ColorUtils.setColorLocked(entity.func_92059_d(), true);
            }
        }
        return false;
    }

    public boolean func_200883_f_(ItemStack stack) {
        return true;
    }

    public int func_200886_f(ItemStack stack) {
        return ColorUtils.getInkColor(stack);
    }

    public void func_200885_a(ItemStack stack, int color) {
        ColorUtils.setInkColor(stack, color);
    }

    public void func_200884_g(ItemStack stack) {
        ColorUtils.setInkColor(stack, -1);
        ColorUtils.setColorLocked(stack, false);
    }
}

