/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.blocks.InkedBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.items.BlockItem;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CauldronBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.server.MinecraftServer;
import net.minecraft.state.Property;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class ColoredBlockItem
extends BlockItem {
    private Item clearItem = null;

    public ColoredBlockItem(Block block, String name, Item.Properties properties, Item clearItem) {
        super(block, properties);
        SplatcraftItems.inkColoredItems.add((Item)this);
        this.setRegistryName(name);
        this.clearItem = clearItem;
    }

    public ColoredBlockItem(Block block, String name, Item.Properties properties) {
        this(block, name, properties, null);
    }

    public ColoredBlockItem(Block block, String name, int stackSize, Item clearItem) {
        this(block, name, new Item.Properties().func_200917_a(stackSize).func_200916_a(SplatcraftItemGroups.GROUP_GENERAL), clearItem);
    }

    public ColoredBlockItem(Block block, String name) {
        this(block, name, 64, null);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(ColorUtils.getFormatedColorName(ColorUtils.getInkColor(stack), true));
    }

    protected boolean func_195943_a(BlockPos pos, World worldIn, @Nullable PlayerEntity player, ItemStack stack, BlockState state) {
        MinecraftServer server = worldIn.func_73046_m();
        if (server == null) {
            return false;
        }
        int color = ColorUtils.getInkColor(stack);
        if (color != -1 && worldIn.func_175625_s(pos) instanceof InkColorTileEntity) {
            ((InkColorTileEntity)worldIn.func_175625_s(pos)).setColor(color);
        }
        return super.func_195943_a(pos, worldIn, player, stack, state);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (this.func_194125_a(group)) {
            for (int color : ColorUtils.STARTER_COLORS) {
                items.add((Object)ColorUtils.setInkColor(new ItemStack((IItemProvider)this), color));
            }
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (ColorUtils.getInkColor(stack) == -1) {
            ColorUtils.setInkColor(stack, entityIn instanceof PlayerEntity && PlayerInfoCapability.hasCapability((LivingEntity)entityIn) ? ColorUtils.getPlayerColor((PlayerEntity)entityIn) : 2039597);
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos = entity.func_233580_cy_();
        if (this.clearItem != null && InkedBlock.causesClear(entity.field_70170_p.func_180495_p(pos))) {
            entity.func_92058_a(new ItemStack((IItemProvider)this.clearItem, stack.func_190916_E()));
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        int i;
        BlockState state = context.func_195991_k().func_180495_p(context.func_195995_a());
        if (state.func_177230_c() instanceof CauldronBlock && context.func_195999_j().func_225608_bj_() && (i = ((Integer)state.func_177229_b((Property)CauldronBlock.field_176591_a)).intValue()) > 0) {
            ItemStack itemstack1 = new ItemStack((IItemProvider)this.clearItem, 1);
            World world = context.func_195991_k();
            PlayerEntity player = context.func_195999_j();
            ItemStack stack = context.func_195996_i();
            context.func_195999_j().func_195066_a(Stats.field_188078_L);
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
                world.func_180501_a(context.func_195995_a(), (BlockState)state.func_206870_a((Property)CauldronBlock.field_176591_a, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(i - 1), (int)0, (int)3))), 2);
                world.func_175666_e(context.func_195995_a(), state.func_177230_c());
            }
            if (stack.func_190926_b()) {
                player.func_184611_a(context.func_221531_n(), itemstack1);
            } else if (!player.field_71071_by.func_70441_a(itemstack1)) {
                player.func_71019_a(itemstack1, false);
            } else if (player instanceof ServerPlayerEntity) {
                ((ServerPlayerEntity)player).func_71120_a((Container)player.field_71069_bz);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }
}

