/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.client.model.AbstractInkTankModel;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.items.ColoredArmorItem;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.SplatcraftArmorMaterial;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.IDyeableArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class InkTankItem
extends ColoredArmorItem
implements IDyeableArmorItem {
    public static final ArrayList<InkTankItem> inkTanks = new ArrayList();
    public final float capacity;
    public final Item.Properties properties;
    @OnlyIn(value=Dist.CLIENT)
    private AbstractInkTankModel model;

    public InkTankItem(String name, float capacity, IArmorMaterial material, Item.Properties properties) {
        super(name, material, EquipmentSlotType.CHEST, properties);
        this.capacity = capacity;
        this.properties = properties;
        SplatcraftItems.weapons.add((Item)this);
        inkTanks.add(this);
        SplatcraftTags.Items.putInkTankTags(this, name);
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            float ink = InkTankItem.getInkAmount(stack);
            if (player.func_184582_a(EquipmentSlotType.CHEST).equals(stack) && ColorUtils.colorEquals((LivingEntity)player, stack) && ink < this.capacity && !(player.func_184607_cu().func_77973_b() instanceof WeaponBaseItem)) {
                InkTankItem.setInkAmount(stack, Math.min(this.capacity, ink + (InkBlockUtils.canSquidHide((LivingEntity)player) && PlayerInfoCapability.isSquid((LivingEntity)player) ? 1.0f : 0.1f)));
            }
        }
    }

    public InkTankItem(String name, float capacity, IArmorMaterial material) {
        this(name, capacity, material, new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_WEAPONS).func_200917_a(1));
    }

    public InkTankItem(String name, InkTankItem parent) {
        this(name, parent.capacity, new SplatcraftArmorMaterial(name, (SplatcraftArmorMaterial)parent.field_200882_e), parent.properties);
    }

    public InkTankItem(String name, float capacity) {
        this(name, capacity, new SplatcraftArmorMaterial(name, SoundEvents.field_187713_n, 0, 0.0f, 0.0f));
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (flag.func_194127_a()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.splatcraft.ink_tank.ink", new Object[]{String.format("%.1f", Float.valueOf(InkTankItem.getInkAmount(stack))), Float.valueOf(this.capacity)}));
        }
    }

    @Nullable
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entity, ItemStack stack, EquipmentSlotType armorSlot, A _default) {
        if (entity.func_130014_f_().field_72995_K) {
            BipedModel model = this.getInkTankModel(entity, stack, this.field_77881_a, _default);
            return (A)(model != null ? model : super.getArmorModel(entity, stack, this.field_77881_a, _default));
        }
        return (A)super.getArmorModel(entity, stack, this.field_77881_a, _default);
    }

    @OnlyIn(value=Dist.CLIENT)
    private BipedModel getInkTankModel(LivingEntity entity, ItemStack stack, EquipmentSlotType slot, BipedModel _default) {
        if (!(stack.func_77973_b() instanceof InkTankItem)) {
            return super.getArmorModel(entity, stack, slot, _default);
        }
        if (this.model == null) {
            return super.getArmorModel(entity, stack, slot, _default);
        }
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof InkTankItem) {
            this.model.field_178721_j.field_78806_j = slot == EquipmentSlotType.LEGS || slot == EquipmentSlotType.FEET;
            this.model.field_178722_k.field_78806_j = slot == EquipmentSlotType.LEGS || slot == EquipmentSlotType.FEET;
            this.model.field_78115_e.field_78806_j = slot == EquipmentSlotType.CHEST;
            this.model.field_178724_i.field_78806_j = slot == EquipmentSlotType.CHEST;
            this.model.field_178723_h.field_78806_j = slot == EquipmentSlotType.CHEST;
            this.model.field_78116_c.field_78806_j = slot == EquipmentSlotType.HEAD;
            this.model.field_178720_f.field_78806_j = slot == EquipmentSlotType.HEAD;
            this.model.field_228270_o_ = _default.field_228270_o_;
            this.model.field_217113_d = _default.field_217113_d;
            this.model.field_217114_e = _default.field_217114_e;
            this.model.field_187076_m = _default.field_187076_m;
            this.model.field_187075_l = _default.field_187075_l;
            this.model.setInkLevels(InkTankItem.getInkAmount(stack) / ((InkTankItem)stack.func_77973_b()).capacity);
            return this.model;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Item setArmorModel(AbstractInkTankModel model) {
        this.model = model;
        return this;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0f - InkTankItem.getInkAmount(stack) / this.capacity;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return ColorUtils.getInkColor(stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("Ink") && InkTankItem.getInkAmount(stack) < this.capacity;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public static float getInkAmount(ItemStack stack) {
        return stack.func_196082_o().func_74760_g("Ink");
    }

    public static float getInkAmount(ItemStack tank, ItemStack weapon) {
        return ((InkTankItem)tank.func_77973_b()).canUse(weapon.func_77973_b()) ? InkTankItem.getInkAmount(tank) : 0.0f;
    }

    public static ItemStack setInkAmount(ItemStack stack, float value) {
        stack.func_77978_p().func_74776_a("Ink", value);
        return stack;
    }

    public boolean canUse(Item item) {
        boolean hasWhitelist = SplatcraftTags.Items.INK_TANK_WHITELIST.get((Object)this).func_230236_b_().size() > 0;
        boolean inWhitelist = SplatcraftTags.Items.INK_TANK_WHITELIST.get((Object)this).func_230235_a_((Object)item);
        boolean inBlacklist = SplatcraftTags.Items.INK_TANK_BLACKLIST.get((Object)this).func_230235_a_((Object)item);
        return !inBlacklist && (hasWhitelist && inWhitelist || !hasWhitelist);
    }

    public void refill(ItemStack stack) {
        InkTankItem.setInkAmount(stack, this.capacity);
    }

    public static void deplete(ItemStack stack) {
        InkTankItem.setInkAmount(stack, 0.0f);
    }
}

