/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items;

import com.cibernet.splatcraft.blocks.InkwellBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.entities.SquidBumperEntity;
import com.cibernet.splatcraft.registries.SplatcraftEntities;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SquidBumperItem
extends Item {
    public SquidBumperItem(String name) {
        super(new Item.Properties().func_200917_a(16).func_200916_a(SplatcraftItemGroups.GROUP_GENERAL));
        SplatcraftItems.inkColoredItems.add(this);
        this.setRegistryName(name);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (ColorUtils.isColorLocked(stack)) {
            tooltip.add(ColorUtils.getFormatedColorName(ColorUtils.getInkColor(stack), true));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof PlayerEntity && !ColorUtils.isColorLocked(stack) && ColorUtils.getInkColor(stack) != ColorUtils.getPlayerColor((PlayerEntity)entity) && PlayerInfoCapability.hasCapability((LivingEntity)entity)) {
            ColorUtils.setInkColor(stack, ColorUtils.getPlayerColor((PlayerEntity)entity));
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        if (entity.field_70170_p.func_180495_p(pos).func_177230_c() instanceof InkwellBlock) {
            InkColorTileEntity te = (InkColorTileEntity)entity.field_70170_p.func_175625_s(pos);
            if (ColorUtils.getInkColor(stack) != ColorUtils.getInkColor(te)) {
                ColorUtils.setInkColor(entity.func_92059_d(), ColorUtils.getInkColor(te));
                ColorUtils.setColorLocked(entity.func_92059_d(), true);
            }
        }
        return false;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (context.func_196000_l() == Direction.DOWN || context.func_195991_k().field_72995_K) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = new BlockItemUseContext(context).func_195995_a();
        ItemStack stack = context.func_195996_i();
        SquidBumperEntity bumper = (SquidBumperEntity)SplatcraftEntities.SQUID_BUMPER.func_220349_b((ServerWorld)world, stack.func_77978_p(), (ITextComponent)null, context.func_195999_j(), pos, SpawnReason.SPAWN_EGG, true, true);
        bumper.setColor(ColorUtils.getInkColor(stack));
        if (world.func_226669_j_((Entity)bumper) && world.func_72839_b((Entity)bumper, bumper.func_174813_aQ()).isEmpty()) {
            if (!world.field_72995_K) {
                float f = (float)MathHelper.func_76141_d((float)((MathHelper.func_76142_g((float)(context.func_195990_h() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                bumper.func_70107_b(bumper.func_226277_ct_(), bumper.func_226278_cu_(), bumper.func_226281_cx_());
                bumper.func_70034_d(f);
                world.func_217376_c((Entity)bumper);
                world.func_184148_a(null, bumper.func_226277_ct_(), bumper.func_226278_cu_(), bumper.func_226281_cx_(), SoundEvents.field_187710_m, SoundCategory.BLOCKS, 0.75f, 0.8f);
            }
            stack.func_190918_g(1);
            return ActionResultType.func_233537_a_((boolean)world.field_72995_K);
        }
        return ActionResultType.FAIL;
    }
}

