/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.remotes;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.blocks.InkwellBlock;
import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.items.remotes.RemoteItem;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.registries.SplatcraftItems;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ColorChangerItem
extends RemoteItem {
    public ColorChangerItem(String name) {
        super(name, new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_GENERAL).func_200917_a(1).func_208103_a(Rarity.UNCOMMON), 3);
        SplatcraftItems.inkColoredItems.add(this);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        if (ColorUtils.isColorLocked(stack)) {
            tooltip.add(ColorUtils.getFormatedColorName(ColorUtils.getInkColor(stack), true));
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof PlayerEntity && !ColorUtils.isColorLocked(stack) && ColorUtils.getInkColor(stack) != ColorUtils.getPlayerColor((PlayerEntity)entity) && PlayerInfoCapability.hasCapability((LivingEntity)entity)) {
            ColorUtils.setInkColor(stack, ColorUtils.getPlayerColor((PlayerEntity)entity));
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        BlockPos pos = entity.func_233580_cy_().func_177977_b();
        if (entity.field_70170_p.func_180495_p(pos).func_177230_c() instanceof InkwellBlock) {
            InkColorTileEntity te = (InkColorTileEntity)entity.field_70170_p.func_175625_s(pos);
            if (ColorUtils.getInkColor(stack) != ColorUtils.getInkColor(te)) {
                ColorUtils.setInkColor(entity.func_92059_d(), ColorUtils.getInkColor(te));
                ColorUtils.setColorLocked(entity.func_92059_d(), true);
            }
        }
        return false;
    }

    @Override
    public RemoteItem.RemoteResult onRemoteUse(World world, BlockPos from, BlockPos to, ItemStack stack, int colorIn, int mode) {
        return ColorChangerItem.replaceColor(world, from, to, colorIn, mode, ColorUtils.getInkColor(stack));
    }

    public static RemoteItem.RemoteResult replaceColor(World world, BlockPos from, BlockPos to, int affectedColor, int mode, int color) {
        BlockPos blockpos2 = new BlockPos(Math.min(from.func_177958_n(), to.func_177958_n()), Math.min(from.func_177956_o(), Math.min(to.func_177956_o(), from.func_177956_o())), Math.min(from.func_177952_p(), to.func_177952_p()));
        BlockPos blockpos3 = new BlockPos(Math.max(from.func_177958_n(), to.func_177958_n()), Math.max(from.func_177956_o(), Math.max(to.func_177956_o(), from.func_177956_o())), Math.max(from.func_177952_p(), to.func_177952_p()));
        if (blockpos2.func_177956_o() < 0 || blockpos3.func_177956_o() >= 256) {
            return ColorChangerItem.createResult(false, (TextComponent)new TranslationTextComponent("status.change_color.out_of_world"));
        }
        for (int j = blockpos2.func_177952_p(); j <= blockpos3.func_177952_p(); j += 16) {
            for (int k = blockpos2.func_177958_n(); k <= blockpos3.func_177958_n(); k += 16) {
                if (world.func_175667_e(new BlockPos(k, blockpos3.func_177956_o() - blockpos2.func_177956_o(), j))) continue;
                return ColorChangerItem.createResult(false, (TextComponent)new TranslationTextComponent("status.change_color.out_of_world"));
            }
        }
        int count = 0;
        int blockTotal = 0;
        for (int x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
            for (int y = blockpos2.func_177956_o(); y <= blockpos3.func_177956_o(); ++y) {
                for (int z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    int teColor;
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block instanceof IColoredBlock && world.func_175625_s(pos) instanceof InkColorTileEntity && (teColor = ((InkColorTileEntity)world.func_175625_s(pos)).getColor()) != affectedColor && (mode == 0 || mode == 1 && teColor == color || mode == 2 && teColor != color) && ((IColoredBlock)block).remoteColorChange(world, pos, affectedColor)) {
                        ++count;
                    }
                    ++blockTotal;
                }
            }
        }
        return ColorChangerItem.createResult(true, (TextComponent)new TranslationTextComponent("status.change_color.success", new Object[]{count, ColorUtils.getFormatedColorName(affectedColor, false)})).setIntResults(count, count * 15 / blockTotal);
    }
}

