/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.remotes;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.items.remotes.RemoteItem;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class InkDisruptorItem
extends RemoteItem {
    public InkDisruptorItem(String name) {
        super(name, new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_GENERAL).func_200917_a(1));
    }

    @Override
    public RemoteItem.RemoteResult onRemoteUse(World world, BlockPos posA, BlockPos posB, ItemStack stack, int colorIn, int mode) {
        BlockPos blockpos2 = new BlockPos(Math.min(posA.func_177958_n(), posB.func_177958_n()), Math.min(posA.func_177956_o(), Math.min(posB.func_177956_o(), posA.func_177956_o())), Math.min(posA.func_177952_p(), posB.func_177952_p()));
        BlockPos blockpos3 = new BlockPos(Math.max(posA.func_177958_n(), posB.func_177958_n()), Math.max(posA.func_177956_o(), Math.max(posB.func_177956_o(), posA.func_177956_o())), Math.max(posA.func_177952_p(), posB.func_177952_p()));
        if (blockpos2.func_177956_o() < 0 || blockpos3.func_177956_o() >= 256) {
            return InkDisruptorItem.createResult(false, (TextComponent)new TranslationTextComponent("status.clear_ink.out_of_world"));
        }
        for (int j = blockpos2.func_177952_p(); j <= blockpos3.func_177952_p(); j += 16) {
            for (int k = blockpos2.func_177958_n(); k <= blockpos3.func_177958_n(); k += 16) {
                if (world.func_175667_e(new BlockPos(k, blockpos3.func_177956_o() - blockpos2.func_177956_o(), j))) continue;
                return InkDisruptorItem.createResult(false, (TextComponent)new TranslationTextComponent("status.clear_ink.out_of_world"));
            }
        }
        int count = 0;
        int blockTotal = 0;
        for (int x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
            for (int y = blockpos2.func_177956_o(); y <= blockpos3.func_177956_o(); ++y) {
                for (int z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    Block block = world.func_180495_p(pos).func_177230_c();
                    if (block instanceof IColoredBlock && ((IColoredBlock)block).remoteInkClear(world, pos)) {
                        ++count;
                    }
                    ++blockTotal;
                }
            }
        }
        return InkDisruptorItem.createResult(true, (TextComponent)new TranslationTextComponent("status.clear_ink." + (count > 0 ? "success" : "no_ink"), new Object[]{count})).setIntResults(count, count * 15 / blockTotal);
    }
}

