/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.remotes;

import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.ColorUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class RemoteItem
extends Item {
    protected final int totalModes;
    public static final List<RemoteItem> remotes = new ArrayList<RemoteItem>();

    public RemoteItem(String name, Item.Properties properties) {
        this(name, properties, 1);
    }

    public RemoteItem(String name, Item.Properties properties, int totalModes) {
        super(properties);
        this.setRegistryName(name);
        remotes.add(this);
        this.totalModes = totalModes;
    }

    public IItemPropertyGetter getActiveProperty() {
        return (stack, world, entity) -> RemoteItem.hasCoordSet(stack) ? 1.0f : 0.0f;
    }

    public IItemPropertyGetter getModeProperty() {
        return (stack, world, entity) -> RemoteItem.getRemoteMode(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT nbt = stack.func_196082_o();
        if (RemoteItem.hasCoordSet(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.remote.coords.b", new Object[]{nbt.func_74762_e("PointAX"), nbt.func_74762_e("PointAY"), nbt.func_74762_e("PointAZ"), nbt.func_74762_e("PointBX"), nbt.func_74762_e("PointBY"), nbt.func_74762_e("PointBZ")}));
        } else if (RemoteItem.hasCoordA(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.remote.coords.a", new Object[]{nbt.func_74762_e("PointAX"), nbt.func_74762_e("PointAY"), nbt.func_74762_e("PointAZ")}));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (RemoteItem.addCoords(context.func_195996_i(), context.func_195995_a())) {
            String key = RemoteItem.hasCoordA(context.func_195996_i()) ? "b" : "a";
            BlockPos pos = context.func_195995_a();
            if (context.func_195991_k().field_72995_K) {
                context.func_195999_j().func_146105_b((ITextComponent)new TranslationTextComponent("status.coord_set." + key, new Object[]{pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()}), true);
            }
            return ActionResultType.SUCCESS;
        }
        return this.func_77659_a(context.func_195991_k(), context.func_195999_j(), context.func_221531_n()).func_188397_a();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        int mode = RemoteItem.getRemoteMode(stack);
        if (playerIn.func_225608_bj_() && this.totalModes > 1) {
            mode = RemoteItem.cycleRemoteMode(stack);
            String statusMsg = this.func_77658_a() + ".mode." + mode;
            if (I18n.func_188566_a((String)statusMsg)) {
                playerIn.func_146105_b((ITextComponent)new TranslationTextComponent("status.remote_mode", new Object[]{new TranslationTextComponent(statusMsg)}), true);
            }
        } else if (RemoteItem.hasCoordSet(stack)) {
            RemoteResult remoteResult = this.onRemoteUse(worldIn, stack, ColorUtils.getPlayerColor(playerIn), mode);
            if (remoteResult.getOutput() != null) {
                playerIn.func_146105_b((ITextComponent)remoteResult.getOutput(), true);
            }
            worldIn.func_184133_a(playerIn, playerIn.func_233580_cy_(), SplatcraftSounds.remoteUse, SoundCategory.BLOCKS, 0.8f, 1.0f);
            return new ActionResult(remoteResult.wasSuccessful() ? ActionResultType.SUCCESS : ActionResultType.FAIL, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public static int getRemoteMode(ItemStack stack) {
        return stack.func_196082_o().func_74762_e("Mode");
    }

    public static void setRemoteMode(ItemStack stack, int mode) {
        stack.func_196082_o().func_74768_a("Mode", mode);
    }

    public static int cycleRemoteMode(ItemStack stack) {
        int mode = RemoteItem.getRemoteMode(stack) + 1;
        if (stack.func_77973_b() instanceof RemoteItem) {
            mode %= ((RemoteItem)stack.func_77973_b()).totalModes;
        }
        RemoteItem.setRemoteMode(stack, mode);
        return mode;
    }

    public static boolean hasCoordSet(ItemStack stack) {
        return RemoteItem.hasCoordA(stack) && RemoteItem.hasCoordB(stack);
    }

    public static boolean hasCoordA(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b("PointAX") && nbt.func_74764_b("PointAY") && nbt.func_74764_b("PointAZ");
    }

    public static boolean hasCoordB(ItemStack stack) {
        CompoundNBT nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74764_b("PointBX") && nbt.func_74764_b("PointBY") && nbt.func_74764_b("PointBZ");
    }

    public static BlockPos[] getCoordSet(ItemStack stack) {
        if (!RemoteItem.hasCoordSet(stack)) {
            return new BlockPos[0];
        }
        CompoundNBT nbt = stack.func_77978_p();
        return new BlockPos[]{new BlockPos(nbt.func_74762_e("PointAX"), nbt.func_74762_e("PointAY"), nbt.func_74762_e("PointAZ")), new BlockPos(nbt.func_74762_e("PointBX"), nbt.func_74762_e("PointBY"), nbt.func_74762_e("PointBZ"))};
    }

    public static boolean addCoords(ItemStack stack, BlockPos pos) {
        if (RemoteItem.hasCoordSet(stack)) {
            return false;
        }
        CompoundNBT nbt = stack.func_77978_p();
        String key = RemoteItem.hasCoordA(stack) ? "B" : "A";
        nbt.func_74768_a("Point" + key + "X", pos.func_177958_n());
        nbt.func_74768_a("Point" + key + "Y", pos.func_177956_o());
        nbt.func_74768_a("Point" + key + "Z", pos.func_177952_p());
        return true;
    }

    public abstract RemoteResult onRemoteUse(World var1, BlockPos var2, BlockPos var3, ItemStack var4, int var5, int var6);

    public RemoteResult onRemoteUse(World world, ItemStack stack, int colorIn, int mode) {
        BlockPos[] coordSet = RemoteItem.getCoordSet(stack);
        BlockPos blockpos = coordSet[0];
        BlockPos blockpos1 = coordSet[1];
        return this.onRemoteUse(world, blockpos, blockpos1, stack, colorIn, mode);
    }

    public static RemoteResult createResult(boolean success, TextComponent output) {
        return new RemoteResult(success, output);
    }

    public static class RemoteResult {
        boolean success;
        TextComponent output;
        int commandResult = 0;
        int comparatorResult = 0;

        public RemoteResult(boolean success, TextComponent output) {
            this.success = success;
            this.output = output;
        }

        public RemoteResult setIntResults(int commandResult, int comparatorResult) {
            this.commandResult = commandResult;
            this.comparatorResult = comparatorResult;
            return this;
        }

        public int getCommandResult() {
            return this.commandResult;
        }

        public int getComparatorResult() {
            return this.comparatorResult;
        }

        public boolean wasSuccessful() {
            return this.success;
        }

        public TextComponent getOutput() {
            return this.output;
        }
    }
}

