/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.remotes;

import com.cibernet.splatcraft.blocks.IColoredBlock;
import com.cibernet.splatcraft.data.tags.SplatcraftTags;
import com.cibernet.splatcraft.handlers.ScoreboardHandler;
import com.cibernet.splatcraft.items.remotes.RemoteItem;
import com.cibernet.splatcraft.network.SendScanTurfResultsPacket;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.registries.SplatcraftItemGroups;
import com.cibernet.splatcraft.tileentities.InkColorTileEntity;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.scoreboard.ScoreCriteria;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TurfScannerItem
extends RemoteItem {
    public TurfScannerItem(String name) {
        super(name, new Item.Properties().func_200916_a(SplatcraftItemGroups.GROUP_GENERAL).func_200917_a(1), 2);
    }

    @Override
    public RemoteItem.RemoteResult onRemoteUse(World world, BlockPos posA, BlockPos posB, ItemStack stack, int colorIn, int mode) {
        return TurfScannerItem.scanTurf(world, posA, posB, mode, null);
    }

    public static RemoteItem.RemoteResult scanTurf(World world, BlockPos blockpos, BlockPos blockpos1, int mode, ServerPlayerEntity target) {
        int color;
        BlockState checkState;
        BlockPos checkPos;
        int y;
        int z;
        int x;
        BlockPos blockpos2 = new BlockPos(Math.min(blockpos.func_177958_n(), blockpos1.func_177958_n()), Math.min(blockpos.func_177956_o(), Math.min(blockpos1.func_177956_o(), blockpos.func_177956_o())), Math.min(blockpos.func_177952_p(), blockpos1.func_177952_p()));
        BlockPos blockpos3 = new BlockPos(Math.max(blockpos.func_177958_n(), blockpos1.func_177958_n()), Math.max(blockpos.func_177956_o(), Math.max(blockpos1.func_177956_o(), blockpos.func_177956_o())), Math.max(blockpos.func_177952_p(), blockpos1.func_177952_p()));
        if (blockpos2.func_177956_o() < 0 || blockpos3.func_177956_o() >= 256) {
            return TurfScannerItem.createResult(false, (TextComponent)new TranslationTextComponent("status.scan_turf.out_of_world"));
        }
        for (int j = blockpos2.func_177952_p(); j <= blockpos3.func_177952_p(); j += 16) {
            for (int k = blockpos2.func_177958_n(); k <= blockpos3.func_177958_n(); k += 16) {
                if (world.func_175667_e(new BlockPos(k, blockpos3.func_177956_o() - blockpos2.func_177956_o(), j))) continue;
                return TurfScannerItem.createResult(false, (TextComponent)new TranslationTextComponent("status.scan_turf.out_of_world"));
            }
        }
        if (world.field_72995_K) {
            return TurfScannerItem.createResult(true, null);
        }
        TreeMap<Integer, Integer> scores = new TreeMap<Integer, Integer>();
        int blockTotal = 0;
        int affectedBlockTotal = 0;
        if (mode == 0) {
            for (x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
                for (z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    y = TurfScannerItem.getTopSolidOrLiquidBlock(new BlockPos(x, 1, z), world, Math.min(blockpos3.func_177956_o() + 2, 255)).func_177977_b().func_177956_o();
                    if (y > blockpos3.func_177956_o() || y < blockpos2.func_177956_o()) continue;
                    checkPos = new BlockPos(x, y, z);
                    checkState = world.func_180495_p(checkPos);
                    if (!InkBlockUtils.canInk(world, checkPos) || !checkState.func_185904_a().func_76230_c() || checkState.func_185904_a().func_76224_d() || !InkBlockUtils.canInk(world, checkPos)) continue;
                    ++blockTotal;
                    if (!(world.func_175625_s(checkPos) instanceof InkColorTileEntity) || !(world.func_180495_p(checkPos).func_177230_c() instanceof IColoredBlock)) continue;
                    InkColorTileEntity te = (InkColorTileEntity)world.func_175625_s(checkPos);
                    IColoredBlock block = (IColoredBlock)world.func_180495_p(checkPos).func_177230_c();
                    color = te.getColor();
                    if (!block.countsTowardsTurf(world, checkPos)) continue;
                    if (scores.containsKey(color)) {
                        scores.replace(color, (Integer)scores.get(color) + 1);
                    } else {
                        scores.put(color, 1);
                    }
                    ++affectedBlockTotal;
                }
            }
        } else if (mode == 1) {
            for (x = blockpos2.func_177958_n(); x <= blockpos3.func_177958_n(); ++x) {
                for (z = blockpos2.func_177952_p(); z <= blockpos3.func_177952_p(); ++z) {
                    for (y = blockpos2.func_177956_o(); y <= blockpos3.func_177956_o(); ++y) {
                        checkPos = new BlockPos(x, y, z);
                        checkState = world.func_180495_p(checkPos);
                        boolean isWall = false;
                        for (int j = 1; j <= 2; ++j) {
                            if (World.func_189509_E((BlockPos)checkPos.func_177981_b(j))) break;
                            if (!InkBlockUtils.canInkPassthrough(world, checkPos.func_177981_b(j))) {
                                isWall = true;
                                break;
                            }
                            if (j > blockpos3.func_177956_o()) break;
                        }
                        if (isWall || !InkBlockUtils.canInk(world, checkPos) || !checkState.func_185904_a().func_76230_c() || checkState.func_185904_a().func_76224_d() || !InkBlockUtils.canInk(world, checkPos)) continue;
                        ++blockTotal;
                        if (!(world.func_175625_s(checkPos) instanceof InkColorTileEntity) || !(world.func_180495_p(checkPos).func_177230_c() instanceof IColoredBlock)) continue;
                        InkColorTileEntity te = (InkColorTileEntity)world.func_175625_s(checkPos);
                        IColoredBlock block = (IColoredBlock)world.func_180495_p(checkPos).func_177230_c();
                        int color2 = te.getColor();
                        if (!block.countsTowardsTurf(world, checkPos)) continue;
                        if (scores.containsKey(color2)) {
                            scores.replace(color2, (Integer)scores.get(color2) + 1);
                            continue;
                        }
                        scores.put(color2, 1);
                    }
                }
            }
        }
        Integer[] colors = new Integer[scores.size()];
        Float[] colorScores = new Float[scores.size()];
        int winner = -1;
        float winnerScore = -1.0f;
        int i = 0;
        for (Map.Entry entry : scores.entrySet()) {
            colors[i] = (Integer)entry.getKey();
            colorScores[i] = Float.valueOf((float)((Integer)entry.getValue()).intValue() / (float)blockTotal * 100.0f);
            if (winnerScore < (float)((Integer)entry.getValue()).intValue()) {
                winner = (Integer)entry.getKey();
                winnerScore = ((Integer)entry.getValue()).intValue();
            }
            ++i;
        }
        for (PlayerEntity player : world.func_217369_A()) {
            color = ColorUtils.getPlayerColor(player);
            if (!ScoreboardHandler.hasColorCriterion(color)) continue;
            ScoreboardHandler.CriteriaInkColor criterion = color == winner ? ScoreboardHandler.getColorWins(color) : ScoreboardHandler.getColorLosses(color);
            world.func_96441_U().func_197893_a((ScoreCriteria)criterion, player.func_195047_I_(), score -> score.func_96649_a(1));
        }
        if (scores.isEmpty()) {
            return TurfScannerItem.createResult(false, (TextComponent)new TranslationTextComponent("status.scan_turf.no_ink"));
        }
        SendScanTurfResultsPacket packet = new SendScanTurfResultsPacket(colors, colorScores);
        if (target == null) {
            SplatcraftPacketHandler.sendToDim(packet, world);
        } else {
            SplatcraftPacketHandler.sendToPlayer(packet, target);
        }
        return TurfScannerItem.createResult(true, null).setIntResults(winner, (int)((float)affectedBlockTotal / (float)blockTotal * 15.0f));
    }

    private static BlockPos getTopSolidOrLiquidBlock(BlockPos pos, World world, int min) {
        BlockPos blockpos1;
        BlockState state;
        Chunk chunk = world.func_175726_f(pos);
        BlockPos blockpos = new BlockPos(pos.func_177958_n(), Math.min(chunk.func_76625_h() + 16, min), pos.func_177952_p());
        while (blockpos.func_177956_o() >= 0 && !SplatcraftTags.Blocks.BLOCKS_TURF.func_230235_a_((Object)(state = chunk.func_180495_p(blockpos1 = blockpos.func_177977_b())).func_177230_c()) && InkBlockUtils.canInkPassthrough(world, blockpos1) && !state.func_185904_a().func_76230_c()) {
            blockpos = blockpos1;
        }
        return blockpos;
    }
}

