/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.weapons;

import com.cibernet.splatcraft.entities.InkProjectileEntity;
import com.cibernet.splatcraft.items.weapons.ShooterItem;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.PlayerCooldown;
import com.cibernet.splatcraft.util.WeaponStat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class BlasterItem
extends ShooterItem {
    public int projLifespan;
    public int startupTicks;
    public int cooldown;
    public float splashDamage;

    public BlasterItem(String name, float projectileSize, float projectileSpeed, float inaccuracy, int startupTicks, int cooldown, float damage, float splashDamage, float inkConsumption, int projectileLifespan) {
        super(name, projectileSize, projectileSpeed, inaccuracy, cooldown, damage, inkConsumption);
        this.projLifespan = projectileLifespan;
        this.startupTicks = startupTicks;
        this.cooldown = cooldown;
        this.splashDamage = splashDamage;
        this.addStat(new WeaponStat("range", (stack, world) -> (int)(projectileSpeed / (float)projectileLifespan * 100.0f)));
        this.addStat(new WeaponStat("impact", (stack, world) -> (int)(damage / 20.0f * 100.0f)));
        this.addStat(new WeaponStat("fire_rate", (stack, world) -> (int)((11.0f - (float)cooldown * 0.5f) * 10.0f)));
    }

    public BlasterItem(String name, BlasterItem parent) {
        this(name, parent.projectileSize, parent.projectileSpeed, parent.inaccuracy, parent.startupTicks, parent.firingSpeed, parent.damage, parent.splashDamage, parent.inkConsumption, parent.projLifespan);
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        super.func_77615_a(stack, world, entity, timeLeft);
        if (BlasterItem.getInkAmount(entity, stack) >= this.inkConsumption && entity instanceof PlayerEntity) {
            CooldownTracker cooldownTracker = ((PlayerEntity)entity).func_184811_cZ();
            cooldownTracker.func_185145_a((Item)this, this.cooldown);
        }
    }

    @Override
    public void weaponUseTick(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        CooldownTracker cooldownTracker = ((PlayerEntity)entity).func_184811_cZ();
        if (BlasterItem.getInkAmount(entity, stack) > this.inkConsumption && !cooldownTracker.func_185141_a((Item)this)) {
            if (entity instanceof PlayerEntity) {
                PlayerCooldown.setPlayerCooldown((PlayerEntity)entity, new PlayerCooldown(this.startupTicks, ((PlayerEntity)entity).field_71071_by.field_70461_c, true, false, true));
                if (!world.field_72995_K) {
                    cooldownTracker.func_185145_a((Item)this, this.cooldown);
                }
            }
        } else if (timeLeft % this.cooldown == 0) {
            BlasterItem.sendNoInkMessage(entity);
        }
    }

    @Override
    public void onPlayerCooldownEnd(World world, PlayerEntity player, ItemStack stack) {
        if (BlasterItem.getInkAmount((LivingEntity)player, stack) >= this.inkConsumption) {
            if (!world.field_72995_K) {
                InkProjectileEntity proj = new InkProjectileEntity(world, (LivingEntity)player, stack, InkBlockUtils.getInkType((LivingEntity)player), this.projectileSize, this.damage).setShooterTrail();
                proj.setBlasterStats(this.projLifespan, this.splashDamage);
                proj.shoot((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.projectileSpeed, this.inaccuracy);
                world.func_217376_c((Entity)proj);
                world.func_184133_a(null, player.func_233580_cy_(), SplatcraftSounds.blasterShot, SoundCategory.PLAYERS, 0.7f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
                BlasterItem.reduceInk((LivingEntity)player, this.inkConsumption);
            }
        } else {
            BlasterItem.sendNoInkMessage((LivingEntity)player, null);
        }
    }
}

