/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.weapons;

import com.cibernet.splatcraft.capabilities.playerinfo.PlayerInfoCapability;
import com.cibernet.splatcraft.entities.InkProjectileEntity;
import com.cibernet.splatcraft.handlers.PlayerPosingHandler;
import com.cibernet.splatcraft.items.weapons.IChargeableWeapon;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.PlayerCharge;
import com.cibernet.splatcraft.util.PlayerCooldown;
import com.cibernet.splatcraft.util.WeaponStat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ChargerItem
extends WeaponBaseItem
implements IChargeableWeapon {
    private final AttributeModifier SPEED_MODIFIER;
    public float projectileSize;
    public float projectileSpeed;
    public int projectileLifespan;
    public float chargeSpeed;
    public float dischargeSpeed;
    public float damage;
    public float minConsumption;
    public float maxConsumption;
    private final double mobility;

    public ChargerItem(String name, float projectileSize, float projectileSpeed, int projectileLifespan, int chargeTime, int dischargeTime, float damage, float minConsumption, float maxConsumption, double mobility) {
        this.setRegistryName(name);
        this.projectileSize = projectileSize;
        this.projectileLifespan = projectileLifespan;
        this.chargeSpeed = 1.0f / (float)chargeTime;
        this.dischargeSpeed = 1.0f / (float)dischargeTime;
        this.damage = damage;
        this.projectileSpeed = projectileSpeed;
        this.mobility = mobility;
        this.SPEED_MODIFIER = new AttributeModifier("Charger Mobility", mobility - 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
        this.maxConsumption = maxConsumption;
        this.minConsumption = minConsumption;
        this.addStat(new WeaponStat("range", (stack, world) -> (int)(projectileSpeed / (float)projectileLifespan * 100.0f)));
        this.addStat(new WeaponStat("charge_speed", (stack, world) -> (int)((float)((40 - chargeTime) * 100) / 40.0f)));
        this.addStat(new WeaponStat("mobility", (stack, world) -> (int)(mobility * 100.0)));
    }

    public ChargerItem(String name, ChargerItem parent) {
        this(name, parent.projectileSize, parent.projectileSpeed, parent.projectileLifespan, (int)(1.0f / parent.chargeSpeed), (int)(1.0f / parent.dischargeSpeed), parent.damage, parent.minConsumption, parent.maxConsumption, parent.mobility);
    }

    @Override
    public float getDischargeSpeed() {
        return this.dischargeSpeed;
    }

    @Override
    public float getChargeSpeed() {
        return this.chargeSpeed;
    }

    @Override
    public void onRelease(World world, PlayerEntity player, ItemStack stack, float charge) {
        InkProjectileEntity proj = new InkProjectileEntity(world, (LivingEntity)player, stack, InkBlockUtils.getInkType((LivingEntity)player), this.projectileSize, charge > 0.95f ? this.damage : this.damage * charge / 4.0f + this.damage / 4.0f);
        proj.setChargerStats((int)((float)this.projectileLifespan * charge));
        proj.shoot((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, this.projectileSpeed, 0.1f);
        world.func_217376_c((Entity)proj);
        world.func_184133_a(null, player.func_233580_cy_(), SplatcraftSounds.blasterShot, SoundCategory.PLAYERS, 0.7f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
        ChargerItem.reduceInk((LivingEntity)player, this.getInkConsumption(charge));
        PlayerCooldown.setPlayerCooldown(player, new PlayerCooldown(10, player.field_71071_by.field_70461_c, true, false, false));
    }

    @Override
    public void weaponUseTick(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (entity instanceof PlayerEntity && ChargerItem.getInkAmount(entity, stack) >= this.getInkConsumption(PlayerCharge.getChargeValue((PlayerEntity)entity, stack))) {
            if (world.field_72995_K) {
                PlayerCharge.addChargeValue((PlayerEntity)entity, stack, this.chargeSpeed);
            }
        } else {
            ChargerItem.sendNoInkMessage(entity, null);
        }
    }

    @Override
    public void func_77615_a(ItemStack stack, World world, LivingEntity entity, int timeLeft) {
        super.func_77615_a(stack, world, entity, timeLeft);
        if (world.field_72995_K && PlayerInfoCapability.isSquid(entity) && entity instanceof PlayerEntity) {
            float charge = PlayerCharge.getChargeValue((PlayerEntity)entity, stack);
            if (charge > 0.05f) {
                PlayerCharge.reset((PlayerEntity)entity);
            }
            PlayerCharge.setCanDischarge((PlayerEntity)entity, true);
        }
    }

    public float getInkConsumption(float charge) {
        return this.minConsumption + (this.maxConsumption - this.minConsumption) * charge;
    }

    @Override
    public PlayerPosingHandler.WeaponPose getPose() {
        return PlayerPosingHandler.WeaponPose.BOW_CHARGE;
    }
}

