/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.weapons;

import com.cibernet.splatcraft.entities.InkProjectileEntity;
import com.cibernet.splatcraft.handlers.PlayerPosingHandler;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.network.DodgeRollPacket;
import com.cibernet.splatcraft.network.SplatcraftPacketHandler;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.ClientUtils;
import com.cibernet.splatcraft.util.ColorUtils;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.InkExplosion;
import com.cibernet.splatcraft.util.PlayerCooldown;
import com.cibernet.splatcraft.util.WeaponStat;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class DualieItem
extends WeaponBaseItem {
    public static final ArrayList<DualieItem> dualies = Lists.newArrayList();
    public float projectileSize;
    public float inaccuracy;
    public float projectileSpeed;
    public int firingSpeed;
    public float damage;
    public float inkConsumption;
    public int maxRolls;
    public float rollSpeed;
    public float rollConsumption;
    public int rollCooldown;
    public int finalRollCooldown;
    public int offhandFiringOffset;
    public boolean canRollFire;

    public DualieItem(String name, float projectileSize, float projectileSpeed, float inaccuracy, int firingSpeed, float damage, float inkConsumption, int rolls, float rollSpeed, float rollConsuption, int rollCooldown, int finalRollCooldown, boolean canRollFire) {
        this.setRegistryName(name);
        this.inaccuracy = inaccuracy;
        this.projectileSize = projectileSize;
        this.projectileSpeed = projectileSpeed;
        this.firingSpeed = firingSpeed;
        this.damage = damage;
        this.inkConsumption = inkConsumption;
        this.maxRolls = rolls;
        this.rollSpeed = rollSpeed;
        this.rollConsumption = rollConsuption;
        this.offhandFiringOffset = firingSpeed / 2;
        this.rollCooldown = rollCooldown;
        this.finalRollCooldown = finalRollCooldown;
        this.canRollFire = canRollFire;
        this.addStat(new WeaponStat("range", (stack, world) -> (int)(projectileSpeed / 1.2f * 100.0f)));
        this.addStat(new WeaponStat("damage", (stack, world) -> (int)(damage / 20.0f * 100.0f)));
        this.addStat(new WeaponStat("mobility", (stack, world) -> (int)(rollSpeed * 100.0f)));
        dualies.add(this);
    }

    public DualieItem(String name, float projectileSize, float projectileSpeed, float inaccuracy, int firingSpeed, float damage, float inkConsumption, int rolls, float rollSpeed, float rollConsuption, int rollCooldown, int finalRollCooldown) {
        this(name, projectileSize, projectileSpeed, inaccuracy, firingSpeed, damage, inkConsumption, rolls, rollSpeed, rollConsuption, rollCooldown, finalRollCooldown, false);
    }

    public DualieItem(String name, DualieItem parent) {
        this(name, parent.projectileSize, parent.projectileSpeed, parent.inaccuracy, parent.firingSpeed, parent.damage, parent.inkConsumption, parent.maxRolls, parent.rollSpeed, parent.rollConsumption, parent.rollCooldown, parent.finalRollCooldown, parent.canRollFire);
    }

    public IItemPropertyGetter getIsLeft() {
        return (stack, world, entity) -> {
            if (entity == null || entity.func_184591_cq() == null) {
                return 0.0f;
            }
            boolean mainLeft = entity.func_184591_cq().equals((Object)HandSide.LEFT);
            return mainLeft && entity.func_184614_ca().equals(stack) || !mainLeft && entity.func_184592_cb().equals(stack) ? 1.0f : 0.0f;
        };
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_196082_o().func_74767_n("IsPlural")) {
            System.out.println("plural");
            return this.func_195935_o() + ".plural";
        }
        return super.func_77667_c(stack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return super.func_200295_i(stack);
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        int rollCooldown;
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        CompoundNBT nbt = stack.func_196082_o();
        nbt.func_74757_a("IsPlural", false);
        if (entity instanceof LivingEntity) {
            Hand hand;
            Hand hand2 = hand = ((LivingEntity)entity).func_184586_b(Hand.MAIN_HAND).equals(stack) ? Hand.MAIN_HAND : Hand.OFF_HAND;
            if (((LivingEntity)entity).func_184586_b(hand).equals(stack) && ((LivingEntity)entity).func_184586_b(Hand.values()[(hand.ordinal() + 1) % Hand.values().length]).func_77973_b().equals(stack.func_77973_b())) {
                nbt.func_74757_a("IsPlural", true);
            }
        }
        if ((rollCooldown = DualieItem.getRollCooldown(stack)) > 0) {
            DualieItem.setRollCooldown(stack, rollCooldown - 1);
        } else if (DualieItem.getRollString(stack) > 0) {
            DualieItem.setRollString(stack, 0);
        }
    }

    @Override
    public void weaponUseTick(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        ItemStack offhandDualie = ItemStack.field_190927_a;
        if (entity.func_184600_cs().equals((Object)Hand.MAIN_HAND) && entity.func_184614_ca().equals(stack) && entity.func_184592_cb().func_77973_b() instanceof DualieItem) {
            offhandDualie = entity.func_184592_cb();
        }
        if (world.field_72995_K) {
            if (entity instanceof PlayerEntity && ClientUtils.canPerformRoll((PlayerEntity)entity)) {
                entity.func_213309_a(DualieItem.performRoll((PlayerEntity)entity, stack, offhandDualie), ClientUtils.getDodgeRollVector((PlayerEntity)entity));
                SplatcraftPacketHandler.sendToServer(new DodgeRollPacket((PlayerEntity)entity, stack, offhandDualie));
            }
        } else {
            boolean rollFire = DualieItem.canRollFire(stack);
            if (offhandDualie.func_77973_b() instanceof DualieItem) {
                boolean bl = rollFire = rollFire && DualieItem.canRollFire(offhandDualie);
                if (!entity.func_233570_aj_() && rollFire || entity.func_233570_aj_()) {
                    ((DualieItem)offhandDualie.func_77973_b()).fireDualie(world, entity, offhandDualie, timeLeft + ((DualieItem)offhandDualie.func_77973_b()).offhandFiringOffset);
                }
            }
            if (!entity.func_233570_aj_() && rollFire || entity.func_233570_aj_()) {
                this.fireDualie(world, entity, stack, timeLeft);
            }
        }
    }

    public static float performRoll(PlayerEntity player, ItemStack mainDualie, ItemStack offhandDualie) {
        ItemStack activeDualie;
        int rollCount = DualieItem.getRollString(mainDualie);
        int maxRolls = 0;
        if (mainDualie.func_77973_b() instanceof DualieItem) {
            maxRolls += ((DualieItem)mainDualie.func_77973_b()).maxRolls;
        }
        if (offhandDualie.func_77973_b() instanceof DualieItem) {
            maxRolls += ((DualieItem)offhandDualie.func_77973_b()).maxRolls;
        }
        if (rollCount >= maxRolls - 1) {
            activeDualie = DualieItem.getRollCooldown(mainDualie, maxRolls, rollCount) >= DualieItem.getRollCooldown(offhandDualie, maxRolls, rollCount) ? mainDualie : offhandDualie;
        } else {
            ItemStack itemStack = activeDualie = maxRolls % 2 == 1 && offhandDualie.func_77973_b() instanceof DualieItem ? offhandDualie : mainDualie;
        }
        if (DualieItem.getInkAmount((LivingEntity)player, activeDualie) >= DualieItem.getInkForRoll(activeDualie)) {
            PlayerCooldown.setPlayerCooldown(player, new PlayerCooldown(DualieItem.getRollCooldown(activeDualie, maxRolls, rollCount), player.field_71071_by.field_70461_c, false, true, false));
            if (!player.field_70170_p.field_72995_K) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SplatcraftSounds.dualieDodge, SoundCategory.PLAYERS, 0.7f, ((player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
                InkExplosion.createInkExplosion(player.field_70170_p, (Entity)player, new DamageSource("ink"), player.func_233580_cy_(), 1.2f, 0.0f, 0.0f, false, ColorUtils.getInkColor(activeDualie), InkBlockUtils.getInkType((LivingEntity)player), activeDualie);
            }
            DualieItem.reduceInk((LivingEntity)player, DualieItem.getInkForRoll(activeDualie));
            DualieItem.setRollString(mainDualie, rollCount + 1);
            DualieItem.setRollCooldown(mainDualie, (int)((float)DualieItem.getRollCooldown(mainDualie, maxRolls, maxRolls) * 0.75f));
            return activeDualie.func_77973_b() instanceof DualieItem ? ((DualieItem)activeDualie.func_77973_b()).rollSpeed : 0.0f;
        }
        if (!player.field_70170_p.field_72995_K) {
            DualieItem.sendNoInkMessage((LivingEntity)player);
        }
        return 0.0f;
    }

    private static float getInkForRoll(ItemStack stack) {
        return stack.func_77973_b() instanceof DualieItem ? ((DualieItem)stack.func_77973_b()).rollConsumption : 0.0f;
    }

    public static int getRollCooldown(ItemStack stack, int maxRolls, int rollCount) {
        if (!(stack.func_77973_b() instanceof DualieItem)) {
            return 0;
        }
        DualieItem dualie = (DualieItem)stack.func_77973_b();
        return rollCount >= maxRolls - 1 ? dualie.finalRollCooldown : dualie.rollCooldown;
    }

    public static boolean canRollFire(ItemStack stack) {
        return stack.func_77973_b() instanceof DualieItem ? ((DualieItem)stack.func_77973_b()).canRollFire : false;
    }

    protected void fireDualie(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (!world.field_72995_K && (this.func_77626_a(stack) - timeLeft - 1) % this.firingSpeed == 0) {
            if (DualieItem.getInkAmount(entity, stack) >= this.inkConsumption) {
                InkProjectileEntity proj = new InkProjectileEntity(world, entity, stack, InkBlockUtils.getInkType(entity), this.projectileSize, this.damage).setShooterTrail();
                proj.shoot((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, this.projectileSpeed, entity instanceof PlayerEntity && PlayerCooldown.hasPlayerCooldown((PlayerEntity)entity) ? 0.0f : this.inaccuracy);
                world.func_217376_c((Entity)proj);
                world.func_184133_a(null, entity.func_233580_cy_(), SplatcraftSounds.dualieShot, SoundCategory.PLAYERS, 0.7f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
                DualieItem.reduceInk(entity, this.inkConsumption);
            } else {
                DualieItem.sendNoInkMessage(entity);
            }
        }
    }

    public static int getRollString(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("RollString")) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("RollString");
    }

    public static ItemStack setRollString(ItemStack stack, int rollString) {
        stack.func_196082_o().func_74768_a("RollString", rollString);
        return stack;
    }

    public static int getRollCooldown(ItemStack stack) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("RollCooldown")) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("RollCooldown");
    }

    public static ItemStack setRollCooldown(ItemStack stack, int rollCooldown) {
        stack.func_196082_o().func_74768_a("RollCooldown", rollCooldown);
        return stack;
    }

    @Override
    public PlayerPosingHandler.WeaponPose getPose() {
        return PlayerPosingHandler.WeaponPose.DUAL_FIRE;
    }
}

