/*
 * Decompiled with CFR 0.152.
 */
package com.cibernet.splatcraft.items.weapons;

import com.cibernet.splatcraft.entities.InkProjectileEntity;
import com.cibernet.splatcraft.handlers.PlayerPosingHandler;
import com.cibernet.splatcraft.items.weapons.BlasterItem;
import com.cibernet.splatcraft.items.weapons.WeaponBaseItem;
import com.cibernet.splatcraft.registries.SplatcraftSounds;
import com.cibernet.splatcraft.util.InkBlockUtils;
import com.cibernet.splatcraft.util.WeaponStat;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ShooterItem
extends WeaponBaseItem {
    public float projectileSize;
    public float projectileSpeed;
    public float inaccuracy;
    public int firingSpeed;
    public float damage;
    public float inkConsumption;

    public ShooterItem(String name, float projectileSize, float projectileSpeed, float inaccuracy, int firingSpeed, float damage, float inkConsumption) {
        this.setRegistryName(name);
        this.projectileSize = projectileSize;
        this.projectileSpeed = projectileSpeed;
        this.inaccuracy = inaccuracy;
        this.firingSpeed = firingSpeed;
        this.damage = damage;
        this.inkConsumption = inkConsumption;
        if (!(this instanceof BlasterItem)) {
            this.addStat(new WeaponStat("range", (stack, world) -> (int)(projectileSpeed / 1.2f * 100.0f)));
            this.addStat(new WeaponStat("damage", (stack, world) -> (int)(damage / 20.0f * 100.0f)));
            this.addStat(new WeaponStat("fire_rate", (stack, world) -> (11 - firingSpeed) * 10));
        }
    }

    public ShooterItem(String name, ShooterItem parent) {
        this(name, parent.projectileSize, parent.projectileSpeed, parent.inaccuracy, parent.firingSpeed, parent.damage, parent.inkConsumption);
    }

    @Override
    public void weaponUseTick(World world, LivingEntity entity, ItemStack stack, int timeLeft) {
        if (!world.field_72995_K && (this.func_77626_a(stack) - timeLeft - 1) % this.firingSpeed == 0) {
            if (ShooterItem.getInkAmount(entity, stack) >= this.inkConsumption) {
                InkProjectileEntity proj = new InkProjectileEntity(world, entity, stack, InkBlockUtils.getInkType(entity), this.projectileSize, this.damage).setShooterTrail();
                proj.shoot((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, this.projectileSpeed, this.inaccuracy);
                world.func_217376_c((Entity)proj);
                world.func_184133_a(null, entity.func_233580_cy_(), SplatcraftSounds.shooterShot, SoundCategory.PLAYERS, 0.7f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f + 1.0f) * 0.95f);
                ShooterItem.reduceInk(entity, this.inkConsumption);
            } else {
                ShooterItem.sendNoInkMessage(entity);
            }
        }
    }

    @Override
    public PlayerPosingHandler.WeaponPose getPose() {
        return PlayerPosingHandler.WeaponPose.FIRE;
    }
}

